/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.BinaryComparable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BytesWritable
extends BinaryComparable
implements WritableComparable<BinaryComparable> {
    private static final Log LOG = LogFactory.getLog(BytesWritable.class);
    private static final int LENGTH_BYTES = 4;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int size;
    private byte[] bytes;

    public BytesWritable() {
        this(EMPTY_BYTES);
    }

    public BytesWritable(byte[] bytes) {
        this.bytes = bytes;
        this.size = bytes.length;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Deprecated
    public byte[] get() {
        return this.getBytes();
    }

    @Override
    public int getLength() {
        return this.size;
    }

    @Deprecated
    public int getSize() {
        return this.getLength();
    }

    public void setSize(int size) {
        if (size > this.getCapacity()) {
            this.setCapacity(size * 3 / 2);
        }
        this.size = size;
    }

    public int getCapacity() {
        return this.bytes.length;
    }

    public void setCapacity(int new_cap) {
        if (new_cap != this.getCapacity()) {
            byte[] new_data = new byte[new_cap];
            if (new_cap < this.size) {
                this.size = new_cap;
            }
            if (this.size != 0) {
                System.arraycopy(this.bytes, 0, new_data, 0, this.size);
            }
            this.bytes = new_data;
        }
    }

    public void set(BytesWritable newData) {
        this.set(newData.bytes, 0, newData.size);
    }

    public void set(byte[] newData, int offset, int length) {
        this.setSize(0);
        this.setSize(length);
        System.arraycopy(newData, offset, this.bytes, 0, this.size);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.setSize(0);
        this.setSize(in.readInt());
        in.readFully(this.bytes, 0, this.size);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.write(this.bytes, 0, this.size);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object right_obj) {
        if (right_obj instanceof BytesWritable) {
            return super.equals(right_obj);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(3 * this.size);
        for (int idx = 0; idx < this.size; ++idx) {
            String num;
            if (idx != 0) {
                sb.append(' ');
            }
            if ((num = Integer.toHexString(0xFF & this.bytes[idx])).length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.toString();
    }

    static {
        WritableComparator.define(BytesWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(BytesWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.compareBytes(b1, s1 + 4, l1 - 4, b2, s2 + 4, l2 - 4);
        }
    }
}

