/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io;

import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BooleanWritable
implements WritableComparable {
    private boolean value;

    public BooleanWritable() {
    }

    public BooleanWritable(boolean value) {
        this.set(value);
    }

    public void set(boolean value) {
        this.value = value;
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readBoolean();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanWritable)) {
            return false;
        }
        BooleanWritable other = (BooleanWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    @Override
    public int compareTo(Object o) {
        boolean a = this.value;
        boolean b = ((BooleanWritable)o).value;
        return a == b ? 0 : (!a ? -1 : 1);
    }

    public String toString() {
        return Boolean.toString(this.get());
    }

    static {
        WritableComparator.define(BooleanWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(BooleanWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            boolean b;
            boolean a = Comparator.readInt(b1, s1) == 1;
            boolean bl = b = Comparator.readInt(b2, s2) == 1;
            return a == b ? 0 : (!a ? -1 : 1);
        }
    }
}

