/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.io;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSDataInputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.DataOutputBuffer;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.MapFile;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparator;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Progressable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.bloom.DynamicBloomFilter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.bloom.Filter;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.bloom.Key;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.hash.Hash;
import java.io.FilterOutputStream;
import java.io.IOException;

public class BloomMapFile {
    private static final Log LOG = LogFactory.getLog(BloomMapFile.class);
    public static final String BLOOM_FILE_NAME = "bloom";
    public static final int HASH_COUNT = 5;

    public static void delete(FileSystem fs, String name) throws IOException {
        Path dir = new Path(name);
        Path data = new Path(dir, "data");
        Path index = new Path(dir, "index");
        Path bloom = new Path(dir, BLOOM_FILE_NAME);
        fs.delete(data, true);
        fs.delete(index, true);
        fs.delete(bloom, true);
        fs.delete(dir, true);
    }

    public static class Reader
    extends MapFile.Reader {
        private DynamicBloomFilter bloomFilter;
        private DataOutputBuffer buf = new DataOutputBuffer();
        private Key bloomKey = new Key();

        public Reader(FileSystem fs, String dirName, Configuration conf) throws IOException {
            super(fs, dirName, conf);
            this.initBloomFilter(fs, dirName, conf);
        }

        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf, boolean open) throws IOException {
            super(fs, dirName, comparator, conf, open);
            this.initBloomFilter(fs, dirName, conf);
        }

        public Reader(FileSystem fs, String dirName, WritableComparator comparator, Configuration conf) throws IOException {
            super(fs, dirName, comparator, conf);
            this.initBloomFilter(fs, dirName, conf);
        }

        private void initBloomFilter(FileSystem fs, String dirName, Configuration conf) {
            try {
                FSDataInputStream in = fs.open(new Path(dirName, BloomMapFile.BLOOM_FILE_NAME));
                this.bloomFilter = new DynamicBloomFilter();
                this.bloomFilter.readFields(in);
                in.close();
            }
            catch (IOException ioe) {
                LOG.warn("Can't open BloomFilter: " + ioe + " - fallback to MapFile.");
                this.bloomFilter = null;
            }
        }

        public boolean probablyHasKey(WritableComparable key) throws IOException {
            if (this.bloomFilter == null) {
                return true;
            }
            this.buf.reset();
            key.write(this.buf);
            this.bloomKey.set(this.buf.getData(), 1.0);
            return this.bloomFilter.membershipTest(this.bloomKey);
        }

        @Override
        public synchronized Writable get(WritableComparable key, Writable val) throws IOException {
            if (!this.probablyHasKey(key)) {
                return null;
            }
            return super.get(key, val);
        }

        public Filter getBloomFilter() {
            return this.bloomFilter;
        }
    }

    public static class Writer
    extends MapFile.Writer {
        private DynamicBloomFilter bloomFilter;
        private int numKeys;
        private int vectorSize;
        private Key bloomKey = new Key();
        private DataOutputBuffer buf = new DataOutputBuffer();
        private FileSystem fs;
        private Path dir;

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class<? extends Writable> valClass, .SequenceFile.CompressionType compress, .CompressionCodec codec, Progressable progress) throws IOException {
            super(conf, fs, dirName, keyClass, valClass, compress, codec, progress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass, .SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            super(conf, fs, dirName, keyClass, valClass, compress, progress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass, .SequenceFile.CompressionType compress) throws IOException {
            super(conf, fs, dirName, keyClass, valClass, compress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, .SequenceFile.CompressionType compress, .CompressionCodec codec, Progressable progress) throws IOException {
            super(conf, fs, dirName, comparator, valClass, compress, codec, progress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, .SequenceFile.CompressionType compress, Progressable progress) throws IOException {
            super(conf, fs, dirName, comparator, valClass, compress, progress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass, .SequenceFile.CompressionType compress) throws IOException {
            super(conf, fs, dirName, comparator, valClass, compress);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, WritableComparator comparator, Class valClass) throws IOException {
            super(conf, fs, dirName, comparator, valClass);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        public Writer(Configuration conf, FileSystem fs, String dirName, Class<? extends WritableComparable> keyClass, Class valClass) throws IOException {
            super(conf, fs, dirName, keyClass, valClass);
            this.fs = fs;
            this.dir = new Path(dirName);
            this.initBloomFilter(conf);
        }

        private synchronized void initBloomFilter(Configuration conf) {
            this.numKeys = conf.getInt("io.mapfile.bloom.size", 0x100000);
            float errorRate = conf.getFloat("io.mapfile.bloom.error.rate", 0.005f);
            this.vectorSize = (int)Math.ceil((double)(-5 * this.numKeys) / Math.log(1.0 - Math.pow(errorRate, 0.2)));
            this.bloomFilter = new DynamicBloomFilter(this.vectorSize, 5, Hash.getHashType(conf), this.numKeys);
        }

        @Override
        public synchronized void append(WritableComparable key, Writable val) throws IOException {
            super.append(key, val);
            this.buf.reset();
            key.write(this.buf);
            this.bloomKey.set(this.buf.getData(), 1.0);
            this.bloomFilter.add(this.bloomKey);
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
            FSDataOutputStream out = this.fs.create(new Path(this.dir, BloomMapFile.BLOOM_FILE_NAME), true);
            this.bloomFilter.write(out);
            out.flush();
            ((FilterOutputStream)out).close();
        }
    }
}

