/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hive.common.io;

import java.io.ByteArrayInputStream;

public class NonSyncByteArrayInputStream
extends ByteArrayInputStream {
    public NonSyncByteArrayInputStream() {
        super(new byte[0]);
    }

    public NonSyncByteArrayInputStream(byte[] bs) {
        super(bs);
    }

    public NonSyncByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public void reset(byte[] input, int start, int length) {
        this.buf = input;
        this.count = start + length;
        this.mark = start;
        this.pos = start;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getLength() {
        return this.count;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }
}

