/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.protocol;

import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactories;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UpgradeCommand
extends DatanodeCommand {
    static final int UC_ACTION_UNKNOWN = 0;
    public static final int UC_ACTION_REPORT_STATUS = 100;
    public static final int UC_ACTION_START_UPGRADE = 101;
    private int version;
    private short upgradeStatus;

    public UpgradeCommand() {
        super(0);
        this.version = 0;
        this.upgradeStatus = 0;
    }

    public UpgradeCommand(int action, int version, short status) {
        super(action);
        this.version = version;
        this.upgradeStatus = status;
    }

    public int getVersion() {
        return this.version;
    }

    public short getCurrentStatus() {
        return this.upgradeStatus;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.version);
        out.writeShort(this.upgradeStatus);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.version = in.readInt();
        this.upgradeStatus = in.readShort();
    }

    static {
        WritableFactories.setFactory(UpgradeCommand.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new UpgradeCommand();
            }
        });
    }
}

