/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.protocol;

import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.protocol.Block;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.Writable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactories;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class BlockCommand
extends DatanodeCommand {
    Block[] blocks;
    DatanodeInfo[][] targets;
    private static final DatanodeInfo[][] EMPTY_TARGET = new DatanodeInfo[0][];

    public BlockCommand() {
    }

    public BlockCommand(int action, List<DatanodeDescriptor.BlockTargetPair> blocktargetlist) {
        super(action);
        this.blocks = new Block[blocktargetlist.size()];
        this.targets = new DatanodeInfo[this.blocks.length][];
        for (int i = 0; i < this.blocks.length; ++i) {
            DatanodeDescriptor.BlockTargetPair p = blocktargetlist.get(i);
            this.blocks[i] = p.block;
            this.targets[i] = p.targets;
        }
    }

    public BlockCommand(int action, Block[] blocks) {
        super(action);
        this.blocks = blocks;
        this.targets = EMPTY_TARGET;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public DatanodeInfo[][] getTargets() {
        return this.targets;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int i;
        super.write(out);
        out.writeInt(this.blocks.length);
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i].write(out);
        }
        out.writeInt(this.targets.length);
        for (i = 0; i < this.targets.length; ++i) {
            out.writeInt(this.targets[i].length);
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j].write(out);
            }
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.blocks = new Block[in.readInt()];
        for (i = 0; i < this.blocks.length; ++i) {
            this.blocks[i] = new Block();
            this.blocks[i].readFields(in);
        }
        this.targets = new DatanodeInfo[in.readInt()][];
        for (i = 0; i < this.targets.length; ++i) {
            this.targets[i] = new DatanodeInfo[in.readInt()];
            for (int j = 0; j < this.targets[i].length; ++j) {
                this.targets[i][j] = new DatanodeInfo();
                this.targets[i][j].readFields(in);
            }
        }
    }

    static {
        WritableFactories.setFactory(BlockCommand.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new BlockCommand();
            }
        });
    }
}

