/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.permission.FsPermission;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.permission.PermissionStatus;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.protocol.Block;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.INode;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import java.io.IOException;
import java.util.List;

class INodeFile
extends INode {
    static final FsPermission UMASK = FsPermission.createImmutable((short)73);
    protected BlocksMap.BlockInfo[] blocks = null;
    protected short blockReplication;
    protected long preferredBlockSize;

    INodeFile(PermissionStatus permissions, int nrBlocks, short replication, long modificationTime, long atime, long preferredBlockSize) {
        this(permissions, new BlocksMap.BlockInfo[nrBlocks], replication, modificationTime, atime, preferredBlockSize);
    }

    protected INodeFile() {
        this.blocks = null;
        this.blockReplication = 0;
        this.preferredBlockSize = 0L;
    }

    protected INodeFile(PermissionStatus permissions, BlocksMap.BlockInfo[] blklist, short replication, long modificationTime, long atime, long preferredBlockSize) {
        super(permissions, modificationTime, atime);
        this.blockReplication = replication;
        this.preferredBlockSize = preferredBlockSize;
        this.blocks = blklist;
    }

    @Override
    protected void setPermission(FsPermission permission) {
        super.setPermission(permission.applyUMask(UMASK));
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    public short getReplication() {
        return this.blockReplication;
    }

    void setReplication(short replication) {
        this.blockReplication = replication;
    }

    BlocksMap.BlockInfo[] getBlocks() {
        return this.blocks;
    }

    void addBlock(BlocksMap.BlockInfo newblock) {
        if (this.blocks == null) {
            this.blocks = new BlocksMap.BlockInfo[1];
            this.blocks[0] = newblock;
        } else {
            int size = this.blocks.length;
            BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size + 1];
            System.arraycopy(this.blocks, 0, newlist, 0, size);
            newlist[size] = newblock;
            this.blocks = newlist;
        }
    }

    void setBlock(int idx, BlocksMap.BlockInfo blk) {
        this.blocks[idx] = blk;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        this.parent = null;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            v.add(blk);
        }
        this.blocks = null;
        return 1;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        long bytes = 0L;
        for (BlocksMap.BlockInfo blk : this.blocks) {
            bytes += blk.getNumBytes();
        }
        summary[0] = summary[0] + bytes;
        summary[1] = summary[1] + 1L;
        summary[3] = summary[3] + this.diskspaceConsumed();
        return summary;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        counts.dsCount += this.diskspaceConsumed();
        return counts;
    }

    long diskspaceConsumed() {
        return this.diskspaceConsumed(this.blocks);
    }

    long diskspaceConsumed(Block[] blkArr) {
        long size = 0L;
        for (Block blk : blkArr) {
            if (blk == null) continue;
            size += blk.getNumBytes();
        }
        if (blkArr.length > 0 && blkArr[blkArr.length - 1] != null && this.isUnderConstruction()) {
            size += this.preferredBlockSize - this.blocks[this.blocks.length - 1].getNumBytes();
        }
        return size * (long)this.blockReplication;
    }

    public long getPreferredBlockSize() {
        return this.preferredBlockSize;
    }

    Block getPenultimateBlock() {
        if (this.blocks == null || this.blocks.length <= 1) {
            return null;
        }
        return this.blocks[this.blocks.length - 2];
    }

    INodeFileUnderConstruction toINodeFileUnderConstruction(String clientName, String clientMachine, DatanodeDescriptor clientNode) throws IOException {
        if (this.isUnderConstruction()) {
            return (INodeFileUnderConstruction)this;
        }
        return new INodeFileUnderConstruction(this.name, this.blockReplication, this.modificationTime, this.preferredBlockSize, this.blocks, this.getPermissionStatus(), clientName, clientMachine, clientNode);
    }
}

