/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.DFSClient;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.datanode.DataNode;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.DfsServlet;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.NameNode;
import com.facebook.presto.hive.$internal.org.apache.hadoop.ipc.RemoteException;
import com.facebook.presto.hive.$internal.org.apache.hadoop.net.NetUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import javax.net.SocketFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.znerd.xmlenc.XMLOutputter;

public class FileChecksumServlets {

    public static class GetServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            UnixUserGroupInformation ugi = this.getUGI(request);
            PrintWriter out = response.getWriter();
            String filename = this.getFilename(request, response);
            XMLOutputter xml = new XMLOutputter((Writer)out, "UTF-8");
            xml.declaration();
            Configuration conf = new Configuration(DataNode.getDataNode().getConf());
            int socketTimeout = conf.getInt("dfs.socket.timeout", 60000);
            SocketFactory socketFactory = NetUtils.getSocketFactory(conf, ClientProtocol.class);
            UnixUserGroupInformation.saveToConf(conf, "hadoop.job.ugi", ugi);
            ClientProtocol nnproxy = DFSClient.createNamenode(conf);
            try {
                MD5MD5CRC32FileChecksum checksum = DFSClient.getFileChecksum(filename, nnproxy, socketFactory, socketTimeout);
                MD5MD5CRC32FileChecksum.write(xml, checksum);
            }
            catch (IOException ioe) {
                new RemoteException(ioe.getClass().getName(), ioe.getMessage()).writeXml(filename, xml);
            }
            xml.endDocument();
        }
    }

    public static class RedirectServlet
    extends DfsServlet {
        private static final long serialVersionUID = 1L;

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            UnixUserGroupInformation ugi = this.getUGI(request);
            ServletContext context = this.getServletContext();
            NameNode namenode = (NameNode)context.getAttribute("name.node");
            DatanodeDescriptor datanode = namenode.namesystem.getRandomDatanode();
            try {
                URI uri = this.createRedirectUri("/getFileChecksum", ugi, datanode, request);
                response.sendRedirect(uri.toURL().toString());
            }
            catch (URISyntaxException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IOException e) {
                response.sendError(400, e.getMessage());
            }
        }
    }
}

