/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode;

import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.common.StorageInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.namenode.FSImage;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.WritableComparable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CheckpointSignature
extends StorageInfo
implements WritableComparable<CheckpointSignature> {
    private static final String FIELD_SEPARATOR = ":";
    long editsTime = -1L;
    long checkpointTime = -1L;

    CheckpointSignature() {
    }

    CheckpointSignature(FSImage fsImage) {
        super(fsImage);
        this.editsTime = fsImage.getEditLog().getFsEditTime();
        this.checkpointTime = fsImage.checkpointTime;
    }

    CheckpointSignature(String str) {
        String[] fields = str.split(FIELD_SEPARATOR);
        assert (fields.length == 5) : "Must be 5 fields in CheckpointSignature";
        this.layoutVersion = Integer.valueOf(fields[0]);
        this.namespaceID = Integer.valueOf(fields[1]);
        this.cTime = Long.valueOf(fields[2]);
        this.editsTime = Long.valueOf(fields[3]);
        this.checkpointTime = Long.valueOf(fields[4]);
    }

    public String toString() {
        return String.valueOf(this.layoutVersion) + FIELD_SEPARATOR + String.valueOf(this.namespaceID) + FIELD_SEPARATOR + String.valueOf(this.cTime) + FIELD_SEPARATOR + String.valueOf(this.editsTime) + FIELD_SEPARATOR + String.valueOf(this.checkpointTime);
    }

    void validateStorageInfo(StorageInfo si) throws IOException {
        if (this.layoutVersion != si.layoutVersion || this.namespaceID != si.namespaceID || this.cTime != si.cTime) {
            throw new IOException("Inconsistent checkpoint fileds. LV = " + this.layoutVersion + " namespaceID = " + this.namespaceID + " cTime = " + this.cTime + ". Expecting respectively: " + si.layoutVersion + "; " + si.namespaceID + "; " + si.cTime);
        }
    }

    @Override
    public int compareTo(CheckpointSignature o) {
        return this.layoutVersion < o.layoutVersion ? -1 : (this.layoutVersion > o.layoutVersion ? 1 : (this.namespaceID < o.namespaceID ? -1 : (this.namespaceID > o.namespaceID ? 1 : (this.cTime < o.cTime ? -1 : (this.cTime > o.cTime ? 1 : (this.editsTime < o.editsTime ? -1 : (this.editsTime > o.editsTime ? 1 : (this.checkpointTime < o.checkpointTime ? -1 : (this.checkpointTime > o.checkpointTime ? 1 : 0)))))))));
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckpointSignature)) {
            return false;
        }
        return this.compareTo((CheckpointSignature)o) == 0;
    }

    public int hashCode() {
        return this.layoutVersion ^ this.namespaceID ^ (int)(this.cTime ^ this.editsTime ^ this.checkpointTime);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        out.writeLong(this.getCTime());
        out.writeLong(this.editsTime);
        out.writeLong(this.checkpointTime);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.cTime = in.readLong();
        this.editsTime = in.readLong();
        this.checkpointTime = in.readLong();
    }
}

