/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.datanode;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.common.HdfsConstants;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.common.Storage;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.common.StorageInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.datanode.DataNode;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.datanode.FSDataset;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.datanode.UpgradeManagerDatanode;
import com.facebook.presto.hive.$internal.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import com.facebook.presto.hive.$internal.org.apache.hadoop.io.IOUtils;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.Daemon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataStorage
extends Storage {
    static final String BLOCK_SUBDIR_PREFIX = "subdir";
    static final String BLOCK_FILE_PREFIX = "blk_";
    static final String COPY_FILE_PREFIX = "dncp_";
    private String storageID;
    private static final Pattern PRE_GENSTAMP_META_FILE_PATTERN = Pattern.compile("(.*blk_[-]*\\d+)\\.meta$");

    DataStorage() {
        super(HdfsConstants.NodeType.DATA_NODE);
        this.storageID = "";
    }

    DataStorage(int nsID, long cT, String strgID) {
        super(HdfsConstants.NodeType.DATA_NODE, nsID, cT);
        this.storageID = strgID;
    }

    public DataStorage(StorageInfo storageInfo, String strgID) {
        super(HdfsConstants.NodeType.DATA_NODE, storageInfo);
        this.storageID = strgID;
    }

    public String getStorageID() {
        return this.storageID;
    }

    void setStorageID(String newStorageID) {
        this.storageID = newStorageID;
    }

    void recoverTransitionRead(NamespaceInfo nsInfo, Collection<File> dataDirs, HdfsConstants.StartupOption startOpt) throws IOException {
        assert (-18 == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
        this.storageID = "";
        this.storageDirs = new ArrayList(dataDirs.size());
        ArrayList<Storage.StorageState> dataDirStates = new ArrayList<Storage.StorageState>(dataDirs.size());
        Iterator<File> it = dataDirs.iterator();
        block7: while (it.hasNext()) {
            Storage.StorageState curState;
            File dataDir = it.next();
            Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir);
            try {
                curState = sd.analyzeStorage(startOpt);
                switch (curState) {
                    case NORMAL: {
                        break;
                    }
                    case NON_EXISTENT: {
                        LOG.info("Storage directory " + dataDir + " does not exist.");
                        it.remove();
                        continue block7;
                    }
                    case NOT_FORMATTED: {
                        LOG.info("Storage directory " + dataDir + " is not formatted.");
                        LOG.info("Formatting ...");
                        this.format(sd, nsInfo);
                        break;
                    }
                    default: {
                        sd.doRecover(curState);
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                sd.unlock();
                throw ioe;
            }
            this.addStorageDir(sd);
            dataDirStates.add(curState);
        }
        if (dataDirs.size() == 0) {
            throw new IOException("All specified directories are not accessible or do not exist.");
        }
        for (int idx = 0; idx < this.getNumStorageDirs(); ++idx) {
            this.doTransition(this.getStorageDir(idx), nsInfo, startOpt);
            assert (this.getLayoutVersion() == nsInfo.getLayoutVersion()) : "Data-node and name-node layout versions must be the same.";
            assert (this.getCTime() == nsInfo.getCTime()) : "Data-node and name-node CTimes must be the same.";
        }
        this.writeAll();
    }

    void format(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        sd.clearDirectory();
        this.layoutVersion = -18;
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        sd.write();
    }

    @Override
    protected void setFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFields(props, sd);
        props.setProperty("storageID", this.storageID);
    }

    @Override
    protected void getFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.getFields(props, sd);
        String ssid = props.getProperty("storageID");
        if (ssid == null || !"".equals(this.storageID) && !"".equals(ssid) && !this.storageID.equals(ssid)) {
            throw new InconsistentFSStateException(sd.getRoot(), "has incompatible storage Id.");
        }
        if ("".equals(this.storageID)) {
            this.storageID = ssid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConversionNeeded(Storage.StorageDirectory sd) throws IOException {
        File oldF = new File(sd.getRoot(), "storage");
        if (!oldF.exists()) {
            return false;
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        try {
            oldFile.seek(0L);
            int oldVersion = oldFile.readInt();
            if (oldVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        return true;
    }

    private void doTransition(Storage.StorageDirectory sd, NamespaceInfo nsInfo, HdfsConstants.StartupOption startOpt) throws IOException {
        if (startOpt == HdfsConstants.StartupOption.ROLLBACK) {
            this.doRollback(sd, nsInfo);
        }
        sd.read();
        DataStorage.checkVersionUpgradable(this.layoutVersion);
        assert (this.layoutVersion >= -18) : "Future version is not allowed";
        if (this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.getRoot().getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (this.layoutVersion == -18 && this.cTime == nsInfo.getCTime()) {
            return;
        }
        this.verifyDistributedUpgradeProgress(nsInfo);
        if (this.layoutVersion > -18 || this.cTime < nsInfo.getCTime()) {
            this.doUpgrade(sd, nsInfo);
            return;
        }
        throw new IOException("Datanode state: LV = " + this.getLayoutVersion() + " CTime = " + this.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
    }

    void doUpgrade(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        LOG.info("Upgrading storage directory " + sd.getRoot() + ".\n   old LV = " + this.getLayoutVersion() + "; old CTime = " + this.getCTime() + ".\n   new LV = " + nsInfo.getLayoutVersion() + "; new CTime = " + nsInfo.getCTime());
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        assert (curDir.exists()) : "Current directory must exist.";
        if (prevDir.exists()) {
            DataStorage.deleteDir(prevDir);
        }
        File tmpDir = sd.getPreviousTmp();
        assert (!tmpDir.exists()) : "previous.tmp directory must not exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.linkBlocks(tmpDir, curDir, this.getLayoutVersion());
        this.layoutVersion = -18;
        assert (this.namespaceID == nsInfo.getNamespaceID()) : "Data-node and name-node layout versions must be the same.";
        this.cTime = nsInfo.getCTime();
        sd.write();
        DataStorage.rename(tmpDir, prevDir);
        LOG.info("Upgrade of " + sd.getRoot() + " is complete.");
    }

    void doRollback(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        DataStorage prevInfo;
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        DataStorage dataStorage = prevInfo = new DataStorage();
        dataStorage.getClass();
        Storage.StorageDirectory prevSD = dataStorage.new Storage.StorageDirectory(sd.getRoot());
        prevSD.read(prevSD.getPreviousVersionFile());
        if (prevInfo.getLayoutVersion() < -18 || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(prevSD.getRoot(), "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + nsInfo.getLayoutVersion() + " CTime = " + nsInfo.getCTime());
        }
        LOG.info("Rolling back storage directory " + sd.getRoot() + ".\n   target LV = " + nsInfo.getLayoutVersion() + "; target CTime = " + nsInfo.getCTime());
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.rename(prevDir, curDir);
        DataStorage.deleteDir(tmpDir);
        LOG.info("Rollback of " + sd.getRoot() + " is complete.");
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.getRoot().getCanonicalPath();
        LOG.info("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime());
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    DataStorage.deleteDir(tmpDir);
                }
                catch (IOException ex) {
                    Storage.LOG.error("Finalize upgrade for " + dataDirPath + " failed.", ex);
                }
                Storage.LOG.info("Finalize upgrade for " + dataDirPath + " is complete.");
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade() throws IOException {
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            this.doFinalize((Storage.StorageDirectory)it.next());
        }
    }

    static void linkBlocks(File from, File to, int oldLV) throws IOException {
        if (!from.isDirectory()) {
            if (from.getName().startsWith(COPY_FILE_PREFIX)) {
                IOUtils.copyBytes((InputStream)new FileInputStream(from), (OutputStream)new FileOutputStream(to), 16384, true);
            } else {
                if (oldLV >= -13) {
                    to = new File(DataStorage.convertMetatadataFileName(to.getAbsolutePath()));
                }
                FileUtil.HardLink.createHardLink(from, to);
            }
            return;
        }
        if (!to.mkdir()) {
            throw new IOException("Cannot create directory " + to);
        }
        String[] blockNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_SUBDIR_PREFIX) || name.startsWith(DataStorage.BLOCK_FILE_PREFIX) || name.startsWith(DataStorage.COPY_FILE_PREFIX);
            }
        });
        for (int i = 0; i < blockNames.length; ++i) {
            DataStorage.linkBlocks(new File(from, blockNames[i]), new File(to, blockNames[i]), oldLV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void corruptPreUpgradeStorage(File rootDir) throws IOException {
        File oldF = new File(rootDir, "storage");
        if (oldF.exists()) {
            return;
        }
        if (!oldF.createNewFile()) {
            throw new IOException("Cannot create file " + oldF);
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        try {
            this.writeCorruptedData(oldFile);
        }
        finally {
            oldFile.close();
        }
    }

    private void verifyDistributedUpgradeProgress(NamespaceInfo nsInfo) throws IOException {
        UpgradeManagerDatanode um = DataNode.getDataNode().upgradeManager;
        assert (um != null) : "DataNode.upgradeManager is null.";
        um.setUpgradeState(false, this.getLayoutVersion());
        um.initializeUpgrade(nsInfo);
    }

    private static String convertMetatadataFileName(String oldFileName) {
        Matcher matcher = PRE_GENSTAMP_META_FILE_PATTERN.matcher(oldFileName);
        if (matcher.matches()) {
            return FSDataset.getMetaFileName(matcher.group(1), 0L);
        }
        return oldFileName;
    }
}

