/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs.kfs;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSInputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.kosmix.kosmosfs.access.KfsAccess;
import org.kosmix.kosmosfs.access.KfsInputChannel;

class KFSInputStream
extends FSInputStream {
    private KfsInputChannel kfsChannel;
    private FileSystem.Statistics statistics;
    private long fsize;

    @Deprecated
    public KFSInputStream(KfsAccess kfsAccess, String path) {
        this(kfsAccess, path, null);
    }

    public KFSInputStream(KfsAccess kfsAccess, String path, FileSystem.Statistics stats) {
        this.statistics = stats;
        this.kfsChannel = kfsAccess.kfs_open(path);
        this.fsize = this.kfsChannel != null ? kfsAccess.kfs_filesize(path) : 0L;
    }

    @Override
    public long getPos() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return this.kfsChannel.tell();
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        return (int)(this.fsize - this.getPos());
    }

    @Override
    public synchronized void seek(long targetPos) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        this.kfsChannel.seek(targetPos);
    }

    @Override
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        byte[] b = new byte[1];
        int res = this.read(b, 0, 1);
        if (res == 1) {
            if (this.statistics != null) {
                this.statistics.incrementBytesRead(1L);
            }
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.kfsChannel == null) {
            throw new IOException("File closed");
        }
        int res = this.kfsChannel.read(ByteBuffer.wrap(b, off, len));
        if (res == 0) {
            return -1;
        }
        if (this.statistics != null) {
            this.statistics.incrementBytesRead(res);
        }
        return res;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.kfsChannel == null) {
            return;
        }
        this.kfsChannel.close();
        this.kfsChannel = null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }
}

