/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.ChecksumFileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.DF;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSDataInputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileUtil;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.RawLocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Random;

public class LocalFileSystem
extends ChecksumFileSystem {
    static final URI NAME = URI.create("file:///");
    private static Random rand = new Random();
    FileSystem rfs;

    public LocalFileSystem() {
        this(new RawLocalFileSystem());
    }

    public FileSystem getRaw() {
        return this.rfs;
    }

    public LocalFileSystem(FileSystem rawLocalFileSystem) {
        super(rawLocalFileSystem);
        this.rfs = rawLocalFileSystem;
    }

    public File pathToFile(Path path) {
        return ((RawLocalFileSystem)this.fs).pathToFile(path);
    }

    @Override
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    @Override
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        FileUtil.copy(this, src, this, dst, delSrc, this.getConf());
    }

    @Override
    public boolean reportChecksumFailure(Path p, FSDataInputStream in, long inPos, FSDataInputStream sums, long sumsPos) {
        try {
            File f = ((RawLocalFileSystem)this.fs).pathToFile(p).getCanonicalFile();
            String device = new DF(f, this.getConf()).getMount();
            File dir = null;
            for (File parent = f.getParentFile(); parent != null && parent.canWrite() && parent.toString().startsWith(device); parent = parent.getParentFile()) {
                dir = parent;
            }
            if (dir == null) {
                throw new IOException("not able to find the highest writable parent dir");
            }
            File badDir = new File(dir, "bad_files");
            if (!badDir.mkdirs() && !badDir.isDirectory()) {
                throw new IOException("Mkdirs failed to create " + badDir.toString());
            }
            String suffix = "." + rand.nextInt();
            File badFile = new File(badDir, f.getName() + suffix);
            LOG.warn("Moving bad file " + f + " to " + badFile);
            in.close();
            f.renameTo(badFile);
            File checkFile = ((RawLocalFileSystem)this.fs).pathToFile(this.getChecksumFile(p));
            checkFile.renameTo(new File(badDir, checkFile.getName() + suffix));
        }
        catch (IOException e) {
            LOG.warn("Error moving bad file " + p + ": " + e);
        }
        return false;
    }
}

