/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.DF;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.DiskChecker;
import com.facebook.presto.hive.$internal.org.apache.hadoop.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class LocalDirAllocator {
    private static Map<String, AllocatorPerContext> contexts = new TreeMap<String, AllocatorPerContext>();
    private String contextCfgItemName;

    public LocalDirAllocator(String contextCfgItemName) {
        this.contextCfgItemName = contextCfgItemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocatorPerContext obtainContext(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            AllocatorPerContext l = contexts.get(contextCfgItemName);
            if (l == null) {
                l = new AllocatorPerContext(contextCfgItemName);
                contexts.put(contextCfgItemName, l);
            }
            return l;
        }
    }

    public Path getLocalPathForWrite(String pathStr, Configuration conf) throws IOException {
        return this.getLocalPathForWrite(pathStr, -1L, conf);
    }

    public Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathForWrite(pathStr, size, conf);
    }

    public Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getLocalPathToRead(pathStr, conf);
    }

    public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.createTmpFileForWrite(pathStr, size, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContextValid(String contextCfgItemName) {
        Map<String, AllocatorPerContext> map = contexts;
        synchronized (map) {
            return contexts.containsKey(contextCfgItemName);
        }
    }

    public boolean ifExists(String pathStr, Configuration conf) {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.ifExists(pathStr, conf);
    }

    int getCurrentDirectoryIndex() {
        AllocatorPerContext context = this.obtainContext(this.contextCfgItemName);
        return context.getCurrentDirectoryIndex();
    }

    private static class AllocatorPerContext {
        private final Log LOG = LogFactory.getLog(AllocatorPerContext.class);
        private int dirNumLastAccessed;
        private Random dirIndexRandomizer = new Random();
        private FileSystem localFS;
        private DF[] dirDF;
        private String contextCfgItemName;
        private String[] localDirs;
        private String savedLocalDirs = "";

        public AllocatorPerContext(String contextCfgItemName) {
            this.contextCfgItemName = contextCfgItemName;
        }

        private void confChanged(Configuration conf) throws IOException {
            String newLocalDirs = conf.get(this.contextCfgItemName);
            if (!newLocalDirs.equals(this.savedLocalDirs)) {
                this.localDirs = conf.getStrings(this.contextCfgItemName);
                this.localFS = FileSystem.getLocal(conf);
                int numDirs = this.localDirs.length;
                ArrayList<String> dirs = new ArrayList<String>(numDirs);
                ArrayList<DF> dfList = new ArrayList<DF>(numDirs);
                for (int i = 0; i < numDirs; ++i) {
                    try {
                        Path tmpDir = new Path(this.localDirs[i]);
                        if (this.localFS.mkdirs(tmpDir) || this.localFS.exists(tmpDir)) {
                            try {
                                DiskChecker.checkDir(new File(this.localDirs[i]));
                                dirs.add(this.localDirs[i]);
                                dfList.add(new DF(new File(this.localDirs[i]), 30000L));
                            }
                            catch (DiskChecker.DiskErrorException de) {
                                this.LOG.warn(this.localDirs[i] + "is not writable\n" + StringUtils.stringifyException(de));
                            }
                            continue;
                        }
                        this.LOG.warn("Failed to create " + this.localDirs[i]);
                        continue;
                    }
                    catch (IOException ie) {
                        this.LOG.warn("Failed to create " + this.localDirs[i] + ": " + ie.getMessage() + "\n" + StringUtils.stringifyException(ie));
                    }
                }
                this.localDirs = dirs.toArray(new String[dirs.size()]);
                this.dirDF = dfList.toArray(new DF[dirs.size()]);
                this.savedLocalDirs = newLocalDirs;
                this.dirNumLastAccessed = this.dirIndexRandomizer.nextInt(dirs.size());
            }
        }

        private Path createPath(String path) throws IOException {
            Path file = new Path(new Path(this.localDirs[this.dirNumLastAccessed]), path);
            try {
                DiskChecker.checkDir(new File(file.getParent().toUri().getPath()));
                return file;
            }
            catch (DiskChecker.DiskErrorException d) {
                this.LOG.warn(StringUtils.stringifyException(d));
                return null;
            }
        }

        int getCurrentDirectoryIndex() {
            return this.dirNumLastAccessed;
        }

        public synchronized Path getLocalPathForWrite(String path, Configuration conf) throws IOException {
            return this.getLocalPathForWrite(path, -1L, conf);
        }

        public synchronized Path getLocalPathForWrite(String pathStr, long size, Configuration conf) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            Path returnPath = null;
            if (size == -1L) {
                long[] availableOnDisk = new long[this.dirDF.length];
                long totalAvailable = 0L;
                for (int i = 0; i < this.dirDF.length; ++i) {
                    availableOnDisk[i] = this.dirDF[i].getAvailable();
                    totalAvailable += availableOnDisk[i];
                }
                Random r = new Random();
                while (numDirsSearched < numDirs && returnPath == null) {
                    long randomPosition = Math.abs(r.nextLong()) % totalAvailable;
                    int dir = 0;
                    while (randomPosition > availableOnDisk[dir]) {
                        randomPosition -= availableOnDisk[dir];
                        ++dir;
                    }
                    this.dirNumLastAccessed = dir;
                    returnPath = this.createPath(pathStr);
                    if (returnPath != null) continue;
                    totalAvailable -= availableOnDisk[dir];
                    availableOnDisk[dir] = 0L;
                    ++numDirsSearched;
                }
            } else {
                while (numDirsSearched < numDirs && returnPath == null) {
                    long capacity = this.dirDF[this.dirNumLastAccessed].getAvailable();
                    if (capacity > size) {
                        returnPath = this.createPath(pathStr);
                    }
                    ++this.dirNumLastAccessed;
                    this.dirNumLastAccessed %= numDirs;
                    ++numDirsSearched;
                }
            }
            if (returnPath != null) {
                return returnPath;
            }
            throw new DiskChecker.DiskErrorException("Could not find any valid local directory for " + pathStr);
        }

        public File createTmpFileForWrite(String pathStr, long size, Configuration conf) throws IOException {
            Path path = this.getLocalPathForWrite(pathStr, size, conf);
            File dir = new File(path.getParent().toUri().getPath());
            String prefix = path.getName();
            File result = File.createTempFile(prefix, null, dir);
            result.deleteOnExit();
            return result;
        }

        public synchronized Path getLocalPathToRead(String pathStr, Configuration conf) throws IOException {
            this.confChanged(conf);
            int numDirs = this.localDirs.length;
            int numDirsSearched = 0;
            if (pathStr.startsWith("/")) {
                pathStr = pathStr.substring(1);
            }
            while (numDirsSearched < numDirs) {
                Path file = new Path(this.localDirs[numDirsSearched], pathStr);
                if (this.localFS.exists(file)) {
                    return file;
                }
                ++numDirsSearched;
            }
            throw new DiskChecker.DiskErrorException("Could not find " + pathStr + " in any of" + " the configured local directories");
        }

        public synchronized boolean ifExists(String pathStr, Configuration conf) {
            try {
                int numDirs = this.localDirs.length;
                int numDirsSearched = 0;
                if (pathStr.startsWith("/")) {
                    pathStr = pathStr.substring(1);
                }
                while (numDirsSearched < numDirs) {
                    Path file = new Path(this.localDirs[numDirsSearched], pathStr);
                    if (this.localFS.exists(file)) {
                        return true;
                    }
                    ++numDirsSearched;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

