/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs;

import com.facebook.presto.hive.$internal.org.apache.hadoop.conf.Configuration;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FileSystem;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

class FsUrlConnection
extends URLConnection {
    private Configuration conf;
    private InputStream is;

    FsUrlConnection(Configuration conf, URL url) {
        super(url);
        this.conf = conf;
    }

    @Override
    public void connect() throws IOException {
        try {
            FileSystem fs = FileSystem.get(this.url.toURI(), this.conf);
            this.is = fs.open(new Path(this.url.getPath()));
        }
        catch (URISyntaxException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.connect();
        }
        return this.is;
    }
}

