/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.PositionedReadable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Seekable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class FSInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    @Override
    public abstract void seek(long var1) throws IOException;

    @Override
    public abstract long getPos() throws IOException;

    @Override
    public abstract boolean seekToNewSource(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        FSInputStream fSInputStream = this;
        synchronized (fSInputStream) {
            long oldPos = this.getPos();
            int nread = -1;
            try {
                this.seek(position);
                nread = this.read(buffer, offset, length);
            }
            finally {
                this.seek(oldPos);
            }
            return nread;
        }
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = this.read(position + (long)nread, buffer, offset + nread, length - nread);
            if (nbytes >= 0) continue;
            throw new EOFException("End of file reached before reading fully.");
        }
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }
}

