/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.org.apache.hadoop.fs;

import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.FSInputStream;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.PositionedReadable;
import com.facebook.presto.hive.$internal.org.apache.hadoop.fs.Seekable;
import java.io.BufferedInputStream;
import java.io.IOException;

public class BufferedFSInputStream
extends BufferedInputStream
implements Seekable,
PositionedReadable {
    public BufferedFSInputStream(FSInputStream in, int size) {
        super(in, size);
    }

    @Override
    public long getPos() throws IOException {
        return ((FSInputStream)this.in).getPos() - (long)(this.count - this.pos);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.seek(this.getPos() + n);
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            return;
        }
        long end = ((FSInputStream)this.in).getPos();
        long start = end - (long)this.count;
        if (pos >= start && pos < end) {
            this.pos = (int)(pos - start);
            return;
        }
        this.pos = 0;
        this.count = 0;
        ((FSInputStream)this.in).seek(pos);
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        this.pos = 0;
        this.count = 0;
        return ((FSInputStream)this.in).seekToNewSource(targetPos);
    }

    @Override
    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        return ((FSInputStream)this.in).read(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        ((FSInputStream)this.in).readFully(position, buffer, offset, length);
    }

    @Override
    public void readFully(long position, byte[] buffer) throws IOException {
        ((FSInputStream)this.in).readFully(position, buffer);
    }
}

