/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.util.StringInterner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ClusterStatus
implements Writable {
    public static final int UNINITIALIZED_MEMORY_VALUE = -1;
    private int numActiveTrackers;
    private Collection<String> activeTrackers = new ArrayList<String>();
    private int numBlacklistedTrackers;
    private int numExcludedNodes;
    private long ttExpiryInterval;
    private int map_tasks;
    private int reduce_tasks;
    private int max_map_tasks;
    private int max_reduce_tasks;
    private Cluster.JobTrackerStatus status;
    private Collection<BlackListInfo> blacklistedTrackersInfo = new ArrayList<BlackListInfo>();

    ClusterStatus() {
    }

    ClusterStatus(int trackers, int blacklists, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, Cluster.JobTrackerStatus status) {
        this(trackers, blacklists, ttExpiryInterval, maps, reduces, maxMaps, maxReduces, status, 0);
    }

    ClusterStatus(int trackers, int blacklists, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, Cluster.JobTrackerStatus status, int numDecommissionedNodes) {
        this.numActiveTrackers = trackers;
        this.numBlacklistedTrackers = blacklists;
        this.numExcludedNodes = numDecommissionedNodes;
        this.ttExpiryInterval = ttExpiryInterval;
        this.map_tasks = maps;
        this.reduce_tasks = reduces;
        this.max_map_tasks = maxMaps;
        this.max_reduce_tasks = maxReduces;
        this.status = status;
    }

    ClusterStatus(Collection<String> activeTrackers, Collection<BlackListInfo> blacklistedTrackers, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, Cluster.JobTrackerStatus status) {
        this(activeTrackers, blacklistedTrackers, ttExpiryInterval, maps, reduces, maxMaps, maxReduces, status, 0);
    }

    ClusterStatus(Collection<String> activeTrackers, Collection<BlackListInfo> blackListedTrackerInfo, long ttExpiryInterval, int maps, int reduces, int maxMaps, int maxReduces, Cluster.JobTrackerStatus status, int numDecommissionNodes) {
        this(activeTrackers.size(), blackListedTrackerInfo.size(), ttExpiryInterval, maps, reduces, maxMaps, maxReduces, status, numDecommissionNodes);
        this.activeTrackers = activeTrackers;
        this.blacklistedTrackersInfo = blackListedTrackerInfo;
    }

    public int getTaskTrackers() {
        return this.numActiveTrackers;
    }

    public Collection<String> getActiveTrackerNames() {
        return this.activeTrackers;
    }

    public Collection<String> getBlacklistedTrackerNames() {
        ArrayList<String> blacklistedTrackers = new ArrayList<String>();
        for (BlackListInfo bi : this.blacklistedTrackersInfo) {
            blacklistedTrackers.add(bi.getTrackerName());
        }
        return blacklistedTrackers;
    }

    public int getBlacklistedTrackers() {
        return this.numBlacklistedTrackers;
    }

    public int getNumExcludedNodes() {
        return this.numExcludedNodes;
    }

    public long getTTExpiryInterval() {
        return this.ttExpiryInterval;
    }

    public int getMapTasks() {
        return this.map_tasks;
    }

    public int getReduceTasks() {
        return this.reduce_tasks;
    }

    public int getMaxMapTasks() {
        return this.max_map_tasks;
    }

    public int getMaxReduceTasks() {
        return this.max_reduce_tasks;
    }

    public Cluster.JobTrackerStatus getJobTrackerStatus() {
        return this.status;
    }

    @Deprecated
    public long getMaxMemory() {
        return -1L;
    }

    @Deprecated
    public long getUsedMemory() {
        return -1L;
    }

    public Collection<BlackListInfo> getBlackListedTrackersInfo() {
        return this.blacklistedTrackersInfo;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (this.activeTrackers.size() == 0) {
            out.writeInt(this.numActiveTrackers);
            out.writeInt(0);
        } else {
            out.writeInt(this.activeTrackers.size());
            out.writeInt(this.activeTrackers.size());
            for (String string : this.activeTrackers) {
                Text.writeString(out, string);
            }
        }
        if (this.blacklistedTrackersInfo.size() == 0) {
            out.writeInt(this.numBlacklistedTrackers);
            out.writeInt(this.blacklistedTrackersInfo.size());
        } else {
            out.writeInt(this.blacklistedTrackersInfo.size());
            out.writeInt(this.blacklistedTrackersInfo.size());
            for (BlackListInfo blackListInfo : this.blacklistedTrackersInfo) {
                blackListInfo.write(out);
            }
        }
        out.writeInt(this.numExcludedNodes);
        out.writeLong(this.ttExpiryInterval);
        out.writeInt(this.map_tasks);
        out.writeInt(this.reduce_tasks);
        out.writeInt(this.max_map_tasks);
        out.writeInt(this.max_reduce_tasks);
        WritableUtils.writeEnum(out, this.status);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.numActiveTrackers = in.readInt();
        int numTrackerNames = in.readInt();
        if (numTrackerNames > 0) {
            for (int i = 0; i < numTrackerNames; ++i) {
                String name = StringInterner.weakIntern(Text.readString(in));
                this.activeTrackers.add(name);
            }
        }
        this.numBlacklistedTrackers = in.readInt();
        int blackListTrackerInfoSize = in.readInt();
        if (blackListTrackerInfoSize > 0) {
            for (int i = 0; i < blackListTrackerInfoSize; ++i) {
                BlackListInfo info = new BlackListInfo();
                info.readFields(in);
                this.blacklistedTrackersInfo.add(info);
            }
        }
        this.numExcludedNodes = in.readInt();
        this.ttExpiryInterval = in.readLong();
        this.map_tasks = in.readInt();
        this.reduce_tasks = in.readInt();
        this.max_map_tasks = in.readInt();
        this.max_reduce_tasks = in.readInt();
        this.status = WritableUtils.readEnum(in, Cluster.JobTrackerStatus.class);
    }

    public static class BlackListInfo
    implements Writable {
        private String trackerName;
        private String reasonForBlackListing;
        private String blackListReport;

        BlackListInfo() {
        }

        public String getTrackerName() {
            return this.trackerName;
        }

        public String getReasonForBlackListing() {
            return this.reasonForBlackListing;
        }

        void setTrackerName(String trackerName) {
            this.trackerName = trackerName;
        }

        void setReasonForBlackListing(String reasonForBlackListing) {
            this.reasonForBlackListing = reasonForBlackListing;
        }

        public String getBlackListReport() {
            return this.blackListReport;
        }

        void setBlackListReport(String blackListReport) {
            this.blackListReport = blackListReport;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.trackerName = StringInterner.weakIntern(Text.readString(in));
            this.reasonForBlackListing = StringInterner.weakIntern(Text.readString(in));
            this.blackListReport = StringInterner.weakIntern(Text.readString(in));
        }

        @Override
        public void write(DataOutput out) throws IOException {
            Text.writeString(out, this.trackerName);
            Text.writeString(out, this.reasonForBlackListing);
            Text.writeString(out, this.blackListReport);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.trackerName);
            sb.append("\t");
            sb.append(this.reasonForBlackListing);
            sb.append("\t");
            sb.append(this.blackListReport.replace("\n", ":"));
            return sb.toString();
        }
    }
}

