/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.IdGenerator;

@InterfaceAudience.Private
public class RandomBlockIdGenerator
implements IdGenerator {
    private final BlockManager blockManager;

    RandomBlockIdGenerator(FSNamesystem namesystem) {
        this.blockManager = namesystem.getBlockManager();
    }

    @Override
    public long nextValue() {
        Block b = new Block(DFSUtil.getRandom().nextLong(), 0L, 0L);
        while (this.isValidBlock(b)) {
            b.setBlockId(DFSUtil.getRandom().nextLong());
        }
        return b.getBlockId();
    }

    private boolean isValidBlock(Block b) {
        return this.blockManager.getBlockCollection(b) != null;
    }
}

