/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hadoop.shaded.org.apache.commons.io.FileUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Shell;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FileUtil {
    private static final Log LOG = LogFactory.getLog(FileUtil.class);

    public static Path[] stat2Paths(FileStatus[] stats) {
        if (stats == null) {
            return null;
        }
        Path[] ret = new Path[stats.length];
        for (int i = 0; i < stats.length; ++i) {
            ret[i] = stats[i].getPath();
        }
        return ret;
    }

    public static Path[] stat2Paths(FileStatus[] stats, Path path) {
        if (stats == null) {
            return new Path[]{path};
        }
        return FileUtil.stat2Paths(stats);
    }

    public static boolean fullyDelete(File dir) {
        if (dir.delete()) {
            return true;
        }
        if (!FileUtil.fullyDeleteContents(dir)) {
            return false;
        }
        return dir.delete();
    }

    public static boolean fullyDeleteContents(File dir) {
        boolean deletionSucceeded = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isFile()) {
                    if (contents[i].delete()) continue;
                    deletionSucceeded = false;
                    continue;
                }
                boolean b = false;
                b = contents[i].delete();
                if (b || FileUtil.fullyDelete(contents[i])) continue;
                deletionSucceeded = false;
            }
        }
        return deletionSucceeded;
    }

    @Deprecated
    public static void fullyDelete(FileSystem fs, Path dir) throws IOException {
        fs.delete(dir, true);
    }

    private static void checkDependencies(FileSystem srcFS, Path src, FileSystem dstFS, Path dst) throws IOException {
        if (srcFS == dstFS) {
            String srcq = src.makeQualified(srcFS).toString() + "/";
            String dstq = dst.makeQualified(dstFS).toString() + "/";
            if (dstq.startsWith(srcq)) {
                if (srcq.length() == dstq.length()) {
                    throw new IOException("Cannot copy " + src + " to itself.");
                }
                throw new IOException("Cannot copy " + src + " to its subdirectory " + dst);
            }
        }
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        return FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, true, conf);
    }

    public static boolean copy(FileSystem srcFS, Path[] srcs, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        boolean gotException = false;
        boolean returnVal = true;
        StringBuilder exceptions = new StringBuilder();
        if (srcs.length == 1) {
            return FileUtil.copy(srcFS, srcs[0], dstFS, dst, deleteSource, overwrite, conf);
        }
        if (!dstFS.exists(dst)) {
            throw new IOException("`" + dst + "': specified destination directory " + "doest not exist");
        }
        FileStatus sdst = dstFS.getFileStatus(dst);
        if (!sdst.isDirectory()) {
            throw new IOException("copying multiple files, but last argument `" + dst + "' is not a directory");
        }
        for (Path src : srcs) {
            try {
                if (FileUtil.copy(srcFS, src, dstFS, dst, deleteSource, overwrite, conf)) continue;
                returnVal = false;
            }
            catch (IOException e) {
                gotException = true;
                exceptions.append(e.getMessage());
                exceptions.append("\n");
            }
        }
        if (gotException) {
            throw new IOException(exceptions.toString());
        }
        return returnVal;
    }

    public static boolean copy(FileSystem srcFS, Path src, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        FileStatus fileStatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, fileStatus, dstFS, dst, deleteSource, overwrite, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, FileSystem dstFS, Path dst, boolean deleteSource, boolean overwrite, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, overwrite);
        if (srcStatus.isDirectory()) {
            FileUtil.checkDependencies(srcFS, src, dstFS, dst);
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], dstFS, new Path(dst, contents[i].getPath().getName()), deleteSource, overwrite, conf);
            }
        } else {
            FSDataInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = srcFS.open(src);
                out = dstFS.create(dst, overwrite);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, true);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyMerge(FileSystem srcFS, Path srcDir, FileSystem dstFS, Path dstFile, boolean deleteSource, Configuration conf, String addString) throws IOException {
        dstFile = FileUtil.checkDest(srcDir.getName(), dstFS, dstFile, false);
        if (!srcFS.getFileStatus(srcDir).isDirectory()) {
            return false;
        }
        FSDataOutputStream out = dstFS.create(dstFile);
        try {
            Object[] contents = srcFS.listStatus(srcDir);
            Arrays.sort(contents);
            for (int i = 0; i < contents.length; ++i) {
                if (!((FileStatus)contents[i]).isFile()) continue;
                FSDataInputStream in = srcFS.open(((FileStatus)contents[i]).getPath());
                try {
                    IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf, false);
                    if (addString == null) continue;
                    ((OutputStream)out).write(addString.getBytes("UTF-8"));
                    continue;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
        finally {
            ((OutputStream)out).close();
        }
        if (deleteSource) {
            return srcFS.delete(srcDir, true);
        }
        return true;
    }

    public static boolean copy(File src, FileSystem dstFS, Path dst, boolean deleteSource, Configuration conf) throws IOException {
        dst = FileUtil.checkDest(src.getName(), dstFS, dst, false);
        if (src.isDirectory()) {
            if (!dstFS.mkdirs(dst)) {
                return false;
            }
            File[] contents = FileUtil.listFiles(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(contents[i], dstFS, new Path(dst, contents[i].getName()), deleteSource, conf);
            }
        } else if (src.isFile()) {
            FileInputStream in = null;
            FSDataOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = dstFS.create(dst);
                IOUtils.copyBytes((InputStream)in, (OutputStream)out, conf);
            }
            catch (IOException e) {
                IOUtils.closeStream(out);
                IOUtils.closeStream(in);
                throw e;
            }
        } else {
            throw new IOException(src.toString() + ": No such file or directory");
        }
        if (deleteSource) {
            return FileUtil.fullyDelete(src);
        }
        return true;
    }

    public static boolean copy(FileSystem srcFS, Path src, File dst, boolean deleteSource, Configuration conf) throws IOException {
        FileStatus filestatus = srcFS.getFileStatus(src);
        return FileUtil.copy(srcFS, filestatus, dst, deleteSource, conf);
    }

    private static boolean copy(FileSystem srcFS, FileStatus srcStatus, File dst, boolean deleteSource, Configuration conf) throws IOException {
        Path src = srcStatus.getPath();
        if (srcStatus.isDirectory()) {
            if (!dst.mkdirs()) {
                return false;
            }
            FileStatus[] contents = srcFS.listStatus(src);
            for (int i = 0; i < contents.length; ++i) {
                FileUtil.copy(srcFS, contents[i], new File(dst, contents[i].getPath().getName()), deleteSource, conf);
            }
        } else {
            FSDataInputStream in = srcFS.open(src);
            IOUtils.copyBytes((InputStream)in, (OutputStream)new FileOutputStream(dst), conf);
        }
        if (deleteSource) {
            return srcFS.delete(src, true);
        }
        return true;
    }

    private static Path checkDest(String srcName, FileSystem dstFS, Path dst, boolean overwrite) throws IOException {
        if (dstFS.exists(dst)) {
            FileStatus sdst = dstFS.getFileStatus(dst);
            if (sdst.isDirectory()) {
                if (null == srcName) {
                    throw new IOException("Target " + dst + " is a directory");
                }
                return FileUtil.checkDest(null, dstFS, new Path(dst, srcName), overwrite);
            }
            if (!overwrite) {
                throw new IOException("Target " + dst + " already exists");
            }
        }
        return dst;
    }

    public static String makeShellPath(String filename) throws IOException {
        if (Path.WINDOWS) {
            return new CygPathCommand(filename).getResult();
        }
        return filename;
    }

    public static String makeShellPath(File file) throws IOException {
        return FileUtil.makeShellPath(file, false);
    }

    public static String makeShellPath(File file, boolean makeCanonicalPath) throws IOException {
        if (makeCanonicalPath) {
            return FileUtil.makeShellPath(file.getCanonicalPath());
        }
        return FileUtil.makeShellPath(file.toString());
    }

    public static long getDU(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (int i = 0; i < allFiles.length; ++i) {
                boolean isSymLink;
                try {
                    isSymLink = FileUtils.isSymlink(allFiles[i]);
                }
                catch (IOException ioe) {
                    isSymLink = true;
                }
                if (isSymLink) continue;
                size += FileUtil.getDU(allFiles[i]);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File inFile, File unzipDir) throws IOException {
        ZipFile zipFile = new ZipFile(inFile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                InputStream in = zipFile.getInputStream(entry);
                try {
                    File file = new File(unzipDir, entry.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    FileOutputStream out = new FileOutputStream(file);
                    try {
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                    finally {
                        ((OutputStream)out).close();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException {
        if (!untarDir.mkdirs() && !untarDir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + untarDir);
        }
        StringBuilder untarCommand = new StringBuilder();
        boolean gzipped = inFile.toString().endsWith("gz");
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(FileUtil.makeShellPath(inFile));
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(FileUtil.makeShellPath(untarDir));
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(FileUtil.makeShellPath(inFile));
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    public static int symLink(String target, String linkname) throws IOException {
        String cmd = "ln -s " + target + " " + linkname;
        Process p = Runtime.getRuntime().exec(cmd, null);
        int returnVal = -1;
        try {
            returnVal = p.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return returnVal;
    }

    public static int chmod(String filename, String perm) throws IOException, InterruptedException {
        return FileUtil.chmod(filename, perm, false);
    }

    public static int chmod(String filename, String perm, boolean recursive) throws IOException, InterruptedException {
        Shell.ShellCommandExecutor shExec;
        block3: {
            StringBuilder cmdBuf = new StringBuilder();
            cmdBuf.append("chmod ");
            if (recursive) {
                cmdBuf.append("-R ");
            }
            cmdBuf.append(perm).append(" ");
            cmdBuf.append(filename);
            String[] shellCmd = new String[]{"bash", "-c", cmdBuf.toString()};
            shExec = new Shell.ShellCommandExecutor(shellCmd);
            try {
                shExec.execute();
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Error while changing permission : " + filename + " Exception: ", e);
            }
        }
        return shExec.getExitCode();
    }

    public static final File createLocalTempFile(File basefile, String prefix, boolean isDeleteOnExit) throws IOException {
        File tmp = File.createTempFile(prefix + basefile.getName(), "", basefile.getParentFile());
        if (isDeleteOnExit) {
            tmp.deleteOnExit();
        }
        return tmp;
    }

    public static void replaceFile(File src, File target) throws IOException {
        if (!src.renameTo(target)) {
            int retries = 5;
            while (target.exists() && !target.delete() && retries-- >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new IOException("replaceFile interrupted.");
                }
            }
            if (!src.renameTo(target)) {
                throw new IOException("Unable to rename " + src + " to " + target);
            }
        }
    }

    public static File[] listFiles(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Invalid directory or I/O error occurred for dir: " + dir.toString());
        }
        return files;
    }

    public static String[] list(File dir) throws IOException {
        String[] fileNames = dir.list();
        if (fileNames == null) {
            throw new IOException("Invalid directory or I/O error occurred for dir: " + dir.toString());
        }
        return fileNames;
    }

    @Deprecated
    public static class HardLink
    extends org.apache.hadoop.fs.HardLink {
    }

    private static class CygPathCommand
    extends Shell {
        String[] command;
        String result;

        CygPathCommand(String path) throws IOException {
            this.command = new String[]{"cygpath", "-u", path};
            this.run();
        }

        String getResult() throws IOException {
            return this.result;
        }

        @Override
        protected String[] getExecString() {
            return this.command;
        }

        @Override
        protected void parseExecResult(BufferedReader lines) throws IOException {
            String line = lines.readLine();
            if (line == null) {
                throw new IOException("Can't convert '" + this.command[2] + " to a cygwin path");
            }
            this.result = line;
        }
    }
}

