/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.s3;

import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.model.StorageObject;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.ThreadWatcher;
import com.facebook.presto.hadoop.shaded.com.cloudera.org.jets3t.service.multi.event.ServiceEvent;

public class MultipartUploadsEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private MultipartUploadsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static MultipartUploadsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static MultipartUploadsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static MultipartUploadsEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] completedObjects, Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static MultipartUploadsEvent newCompletedEvent(Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(2, uniqueOperationId);
        return event;
    }

    public static MultipartUploadsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static MultipartUploadsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        MultipartUploadsEvent event = new MultipartUploadsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getUploadedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

