/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyIntTreeReader;
import com.facebook.hive.orc.lazy.LazyLongDictionaryTreeReader;
import com.facebook.hive.orc.lazy.LazyLongDirectTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LazyLongTreeReader
extends LazyIntTreeReader {
    public LazyLongTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        switch (encodings.get(this.columnId).getKind()) {
            case DICTIONARY: {
                this.reader = new LazyLongDictionaryTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            case DIRECT: {
                this.reader = new LazyLongDirectTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)encodings.get(this.columnId).getKind()));
            }
        }
        this.reader.startStripe(streams, encodings, indexes, rowBaseInStripe);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }
}

