/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.FBSettableUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObject;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class OrcUnion
implements UnionObject {
    private byte tag;
    private Object object;

    public void set(byte tag, Object object) {
        this.tag = tag;
        this.object = object;
    }

    public byte getTag() {
        return this.tag;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcUnion.class) {
            return false;
        }
        OrcUnion oth = (OrcUnion)other;
        if (this.tag != oth.tag) {
            return false;
        }
        if (this.object == null) {
            return oth.object == null;
        }
        return this.object.equals(oth.object);
    }

    public int hashCode() {
        int result = this.tag;
        if (this.object != null) {
            result ^= this.object.hashCode();
        }
        return result;
    }

    public String toString() {
        return "union(" + Integer.toString(this.tag & 0xFF) + ", " + this.object.toString() + ")";
    }

    public static class OrcUnionObjectInspector
    implements FBSettableUnionObjectInspector {
        private final List<ObjectInspector> children;

        public OrcUnionObjectInspector(int columnId, List<OrcProto.Type> types) {
            OrcProto.Type type = types.get(columnId);
            this.children = new ArrayList<ObjectInspector>(type.getSubtypesCount());
            for (int i = 0; i < type.getSubtypesCount(); ++i) {
                this.children.add(OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(i), types));
            }
        }

        public OrcUnionObjectInspector(UnionTypeInfo info) {
            List unionChildren = info.getAllUnionObjectTypeInfos();
            this.children = new ArrayList<ObjectInspector>(unionChildren.size());
            for (TypeInfo child : info.getAllUnionObjectTypeInfos()) {
                this.children.add(OrcLazyObjectInspectorUtils.createWritableObjectInspector(child));
            }
        }

        public List<ObjectInspector> getObjectInspectors() {
            return this.children;
        }

        public byte getTag(Object obj) {
            return ((OrcUnion)obj).tag;
        }

        public Object getField(Object obj) {
            return ((OrcUnion)obj).object;
        }

        public String getTypeName() {
            StringBuilder builder = new StringBuilder("uniontype<");
            boolean first = true;
            for (ObjectInspector child : this.children) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(child.getTypeName());
            }
            builder.append(">");
            return builder.toString();
        }

        public ObjectInspector.Category getCategory() {
            return ObjectInspector.Category.UNION;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            List<ObjectInspector> other = ((OrcUnionObjectInspector)o).children;
            if (other.size() != this.children.size()) {
                return false;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                if (other.get(i).equals(this.children.get(i))) continue;
                return false;
            }
            return true;
        }

        public Object create() {
            return new OrcUnion();
        }

        public void setField(Object union, byte tag, Object object) {
            ((OrcUnion)union).set(tag, object);
        }
    }
}

