/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.update;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constant.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.mysql.sql.MySQLUpdateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql.OracleUpdateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.postgresql.sql.PostgreSQLUpdateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.sqlserver.sql.SQLServerUpdateParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.update.AbstractUpdateParser;

public final class UpdateParserFactory {
    public static AbstractUpdateParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLUpdateParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleUpdateParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerUpdateParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLUpdateParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private UpdateParserFactory() {
    }
}

