/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.DefaultKeyword;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.token.Symbol;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.clause.facade.AbstractInsertClauseParserFacade;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.SQLParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.DMLStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dml.insert.InsertStatement;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.GeneratedKeyToken;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.token.ItemsToken;
import com.google.common.base.Optional;

public abstract class AbstractInsertParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AbstractInsertClauseParserFacade insertClauseParserFacade;

    public AbstractInsertParser(ShardingRule shardingRule, LexerEngine lexerEngine, AbstractInsertClauseParserFacade insertClauseParserFacade) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.insertClauseParserFacade = insertClauseParserFacade;
    }

    @Override
    public final DMLStatement parse() {
        this.lexerEngine.nextToken();
        InsertStatement result = new InsertStatement();
        this.insertClauseParserFacade.getInsertIntoClauseParser().parse(result);
        this.insertClauseParserFacade.getInsertColumnsClauseParser().parse(result);
        if (this.lexerEngine.equalAny(DefaultKeyword.SELECT, Symbol.LEFT_PAREN)) {
            throw new UnsupportedOperationException("Cannot INSERT SELECT");
        }
        this.insertClauseParserFacade.getInsertValuesClauseParser().parse(result);
        this.insertClauseParserFacade.getInsertSetClauseParser().parse(result);
        this.appendGenerateKey(result);
        return result;
    }

    private void appendGenerateKey(InsertStatement insertStatement) {
        String tableName = insertStatement.getTables().getSingleTableName();
        Optional<String> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
        if (!generateKeyColumn.isPresent() || null != insertStatement.getGeneratedKey()) {
            return;
        }
        ItemsToken columnsToken = new ItemsToken(insertStatement.getColumnsListLastPosition());
        columnsToken.getItems().add((String)generateKeyColumn.get());
        insertStatement.getSqlTokens().add(columnsToken);
        insertStatement.getSqlTokens().add(new GeneratedKeyToken(insertStatement.getValuesListLastPosition()));
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

