/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.sql;

import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.parsing.lexer.LexerEngine;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.clause.OracleForClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.clause.OracleHierarchicalQueryClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.clause.OracleModelClauseParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.dialect.oracle.clause.facade.OracleSelectClauseParserFacade;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.AbstractSelectParser;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.sql.dql.select.SelectStatement;

public final class OracleSelectParser
extends AbstractSelectParser {
    private final OracleHierarchicalQueryClauseParser hierarchicalQueryClauseParser;
    private final OracleModelClauseParser modelClauseParser;
    private final OracleForClauseParser forClauseParser;

    public OracleSelectParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine, new OracleSelectClauseParserFacade(shardingRule, lexerEngine));
        this.hierarchicalQueryClauseParser = new OracleHierarchicalQueryClauseParser(lexerEngine);
        this.modelClauseParser = new OracleModelClauseParser(lexerEngine);
        this.forClauseParser = new OracleForClauseParser(lexerEngine);
    }

    @Override
    protected void parseInternal(SelectStatement selectStatement) {
        this.parseDistinct();
        this.parseSelectList(selectStatement, this.getItems());
        this.parseFrom(selectStatement);
        this.parseWhere(this.getShardingRule(), selectStatement, this.getItems());
        this.parseHierarchicalQueryClause();
        this.parseGroupBy(selectStatement);
        this.parseHaving();
        this.parseModelClause();
        this.parseOrderBy(selectStatement);
        this.parseFor(selectStatement);
        this.parseSelectRest();
    }

    private void parseHierarchicalQueryClause() {
        this.hierarchicalQueryClauseParser.parse();
    }

    private void parseModelClause() {
        this.modelClauseParser.parse();
    }

    private void parseFor(SelectStatement selectStatement) {
        this.forClauseParser.parse(selectStatement);
    }
}

