/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.constant.ShardingOperator;
import com.dangdang.ddframe.rdb.sharding.exception.ShardingJdbcException;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.context.condition.Column;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLNumberExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLPlaceholderExpression;
import com.dangdang.ddframe.rdb.sharding.parsing.parser.expression.SQLTextExpression;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Condition {
    private final Column column;
    private final ShardingOperator operator;
    private final Map<Integer, Comparable<?>> positionValueMap = new LinkedHashMap();
    private final Map<Integer, Integer> positionIndexMap = new LinkedHashMap<Integer, Integer>();

    public Condition(Column column, SQLExpression sqlExpression) {
        this(column, ShardingOperator.EQUAL);
        this.init(sqlExpression, 0);
    }

    public Condition(Column column, SQLExpression beginSQLExpression, SQLExpression endSQLExpression) {
        this(column, ShardingOperator.BETWEEN);
        this.init(beginSQLExpression, 0);
        this.init(endSQLExpression, 1);
    }

    public Condition(Column column, List<SQLExpression> sqlExpressions) {
        this(column, ShardingOperator.IN);
        int count = 0;
        for (SQLExpression each : sqlExpressions) {
            this.init(each, count);
            ++count;
        }
    }

    private void init(SQLExpression sqlExpression, int position) {
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            this.positionIndexMap.put(position, ((SQLPlaceholderExpression)sqlExpression).getIndex());
        } else if (sqlExpression instanceof SQLTextExpression) {
            this.positionValueMap.put(position, (Comparable<?>)((Object)((SQLTextExpression)sqlExpression).getText()));
        } else if (sqlExpression instanceof SQLNumberExpression) {
            this.positionValueMap.put(position, (Comparable)((Object)((SQLNumberExpression)sqlExpression).getNumber()));
        }
    }

    public ShardingValue<?> getShardingValue(List<Object> parameters) {
        List<Comparable<?>> conditionValues = this.getValues(parameters);
        switch (this.operator) {
            case EQUAL: {
                return new ShardingValue(this.column.getTableName(), this.column.getName(), conditionValues.get(0));
            }
            case IN: {
                return new ShardingValue(this.column.getTableName(), this.column.getName(), conditionValues);
            }
            case BETWEEN: {
                return new ShardingValue(this.column.getTableName(), this.column.getName(), Range.range(conditionValues.get(0), (BoundType)BoundType.CLOSED, conditionValues.get(1), (BoundType)BoundType.CLOSED));
            }
        }
        throw new UnsupportedOperationException(this.operator.getExpression());
    }

    private List<Comparable<?>> getValues(List<Object> parameters) {
        LinkedList result = new LinkedList(this.positionValueMap.values());
        for (Map.Entry<Integer, Integer> entry : this.positionIndexMap.entrySet()) {
            Object parameter = parameters.get(entry.getValue());
            if (!(parameter instanceof Comparable)) {
                throw new ShardingJdbcException("Parameter `%s` should extends Comparable for sharding value.", parameter);
            }
            if (entry.getKey() < result.size()) {
                result.add(entry.getKey(), (Comparable)parameter);
                continue;
            }
            result.add((Comparable)parameter);
        }
        return result;
    }

    private Condition(Column column, ShardingOperator operator) {
        this.column = column;
        this.operator = operator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)o;
        Column this$column = this.getColumn();
        Column other$column = other.getColumn();
        if (this$column == null ? other$column != null : !((Object)this$column).equals(other$column)) {
            return false;
        }
        ShardingOperator this$operator = this.getOperator();
        ShardingOperator other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)((Object)this$operator)).equals((Object)other$operator)) {
            return false;
        }
        Map<Integer, Comparable<?>> this$positionValueMap = this.positionValueMap;
        Map<Integer, Comparable<?>> other$positionValueMap = other.positionValueMap;
        if (this$positionValueMap == null ? other$positionValueMap != null : !((Object)this$positionValueMap).equals(other$positionValueMap)) {
            return false;
        }
        Map<Integer, Integer> this$positionIndexMap = this.positionIndexMap;
        Map<Integer, Integer> other$positionIndexMap = other.positionIndexMap;
        return !(this$positionIndexMap == null ? other$positionIndexMap != null : !((Object)this$positionIndexMap).equals(other$positionIndexMap));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Column $column = this.getColumn();
        result = result * 59 + ($column == null ? 0 : ((Object)$column).hashCode());
        ShardingOperator $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 0 : ((Object)((Object)$operator)).hashCode());
        Map<Integer, Comparable<?>> $positionValueMap = this.positionValueMap;
        result = result * 59 + ($positionValueMap == null ? 0 : ((Object)$positionValueMap).hashCode());
        Map<Integer, Integer> $positionIndexMap = this.positionIndexMap;
        result = result * 59 + ($positionIndexMap == null ? 0 : ((Object)$positionIndexMap).hashCode());
        return result;
    }

    public String toString() {
        return "Condition(column=" + this.getColumn() + ", operator=" + (Object)((Object)this.getOperator()) + ", positionValueMap=" + this.positionValueMap + ", positionIndexMap=" + this.positionIndexMap + ")";
    }

    public Column getColumn() {
        return this.column;
    }

    public ShardingOperator getOperator() {
        return this.operator;
    }
}

