/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.database;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.api.rule.DataSourceRule;
import com.dangdang.ddframe.rdb.sharding.api.strategy.database.DatabaseShardingStrategy;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.hint.ShardingKey;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.database.DatabaseRoutingResult;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRouter {
    private static final Logger log = LoggerFactory.getLogger(DatabaseRouter.class);
    private final DataSourceRule dataSourceRule;
    private final DatabaseShardingStrategy databaseShardingStrategy;
    private final SQLStatementType sqlStatementType;

    public DatabaseRoutingResult route() {
        Optional<ShardingValue<?>> shardingValueOptional = HintManagerHolder.getDatabaseShardingValue(new ShardingKey("DB_TABLE_NAME", "DB_COLUMN_NAME"));
        Preconditions.checkState((boolean)shardingValueOptional.isPresent());
        log.debug("Before database sharding only db:{} sharding values: {}", this.dataSourceRule.getDataSourceNames(), shardingValueOptional.get());
        Collection<String> routedResult = this.databaseShardingStrategy.doStaticSharding(this.sqlStatementType, this.dataSourceRule.getDataSourceNames(), Collections.singleton(shardingValueOptional.get()));
        Preconditions.checkState((!routedResult.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        log.debug("After database sharding only result: {}", routedResult);
        return new DatabaseRoutingResult(routedResult);
    }

    @ConstructorProperties(value={"dataSourceRule", "databaseShardingStrategy", "sqlStatementType"})
    public DatabaseRouter(DataSourceRule dataSourceRule, DatabaseShardingStrategy databaseShardingStrategy, SQLStatementType sqlStatementType) {
        this.dataSourceRule = dataSourceRule;
        this.databaseShardingStrategy = databaseShardingStrategy;
        this.sqlStatementType = sqlStatementType;
    }
}

