/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.pipeline.reducer;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMergeContext;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.delegate.AbstractDelegateResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.OrderByResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamingOrderByReducerResultSet
extends AbstractDelegateResultSet {
    private static final Logger log = LoggerFactory.getLogger(StreamingOrderByReducerResultSet.class);
    private final Queue<ResultSetOrderByWrapper> delegateResultSetQueue = new PriorityQueue<ResultSetOrderByWrapper>(this.getResultSets().size());
    private final List<OrderByColumn> orderByKeys;

    public StreamingOrderByReducerResultSet(ResultSetMergeContext resultSetMergeContext) throws SQLException {
        super(resultSetMergeContext.getShardingResultSets().getResultSets());
        this.orderByKeys = resultSetMergeContext.getCurrentOrderByKeys();
    }

    @Override
    protected boolean firstNext() throws SQLException {
        for (ResultSet each : this.getResultSets()) {
            ResultSetOrderByWrapper wrapper = new ResultSetOrderByWrapper(each);
            if (!wrapper.next()) continue;
            this.delegateResultSetQueue.offer(wrapper);
        }
        return this.doNext();
    }

    @Override
    protected boolean afterFirstNext() throws SQLException {
        ResultSetOrderByWrapper firstResultSet = this.delegateResultSetQueue.poll();
        this.setDelegate(firstResultSet.delegate);
        if (firstResultSet.next()) {
            this.delegateResultSetQueue.offer(firstResultSet);
        }
        return this.doNext();
    }

    private boolean doNext() {
        if (this.delegateResultSetQueue.isEmpty()) {
            return false;
        }
        this.setDelegate(this.delegateResultSetQueue.peek().delegate);
        log.trace("Chosen order by value: {}, current result set hashcode: {}", (Object)this.delegateResultSetQueue.peek().row, (Object)this.getDelegate().hashCode());
        return true;
    }

    private class ResultSetOrderByWrapper
    implements Comparable<ResultSetOrderByWrapper> {
        private final ResultSet delegate;
        private OrderByResultSetRow row;

        boolean next() throws SQLException {
            boolean result = this.delegate.next();
            if (result) {
                this.row = new OrderByResultSetRow(this.delegate, StreamingOrderByReducerResultSet.this.orderByKeys);
            }
            return result;
        }

        @Override
        public int compareTo(ResultSetOrderByWrapper o) {
            return this.row.compareTo(o.row);
        }

        @ConstructorProperties(value={"delegate"})
        public ResultSetOrderByWrapper(ResultSet delegate) {
            this.delegate = delegate;
        }
    }
}

