/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.jdbc;

import com.dangdang.ddframe.rdb.sharding.api.strategy.slave.RoundRobinSlaveLoadBalanceStrategy;
import com.dangdang.ddframe.rdb.sharding.api.strategy.slave.SlaveLoadBalanceStrategy;
import com.dangdang.ddframe.rdb.sharding.hint.HintManagerHolder;
import com.dangdang.ddframe.rdb.sharding.jdbc.adapter.AbstractDataSourceAdapter;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;

public final class MasterSlaveDataSource
extends AbstractDataSourceAdapter {
    private static final ThreadLocal<Boolean> DML_FLAG = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final String name;
    private final DataSource masterDataSource;
    private final List<DataSource> slaveDataSources;
    private final SlaveLoadBalanceStrategy slaveLoadBalanceStrategy = new RoundRobinSlaveLoadBalanceStrategy();

    static boolean isDML(SQLStatementType sqlStatementType) {
        return SQLStatementType.SELECT != sqlStatementType || DML_FLAG.get() != false || HintManagerHolder.isMasterRouteOnly();
    }

    public DataSource getDataSource(SQLStatementType sqlStatementType) {
        if (MasterSlaveDataSource.isDML(sqlStatementType)) {
            DML_FLAG.set(true);
            return this.masterDataSource;
        }
        return this.slaveLoadBalanceStrategy.getDataSource(this.name, this.slaveDataSources);
    }

    String getDatabaseProductName() throws SQLException {
        String result;
        try (Connection masterConnection = this.masterDataSource.getConnection();){
            result = masterConnection.getMetaData().getDatabaseProductName();
        }
        for (DataSource each : this.slaveDataSources) {
            String slaveDatabaseProductName;
            try (Connection slaveConnection = each.getConnection();){
                slaveDatabaseProductName = slaveConnection.getMetaData().getDatabaseProductName();
            }
            Preconditions.checkState((boolean)result.equals(slaveDatabaseProductName), (Object)String.format("Database type inconsistent with '%s' and '%s'", result, slaveDatabaseProductName));
        }
        return result;
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException("Master slave data source cannot support get connection directly.");
    }

    public static void resetDMLFlag() {
        DML_FLAG.remove();
    }

    @ConstructorProperties(value={"name", "masterDataSource", "slaveDataSources"})
    public MasterSlaveDataSource(String name, DataSource masterDataSource, List<DataSource> slaveDataSources) {
        this.name = name;
        this.masterDataSource = masterDataSource;
        this.slaveDataSources = slaveDataSources;
    }
}

