/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;

class TailInputStream
extends InputStream {
    private static final long TAIL_CHECK_DELAY = 250L;
    private RandomAccessFile raf;
    private volatile boolean closed;

    public TailInputStream(Path path) {
        this.raf = new RandomAccessFile(path.toFile(), "r");
    }

    @Override
    public int read() {
        if (this.closed) {
            return -1;
        }
        try {
            int n;
            while ((n = this.raf.read()) == -1) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
            return n;
        }
        catch (IOException iOException) {
            if (this.closed) {
                return -1;
            }
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        if (this.closed) {
            return -1;
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3 = this.raf.read(byArray, n, n2);
            if (n3 == -1) {
                do {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                } while ((n3 = this.raf.read(byArray, n, n2)) == -1);
            }
            return n3;
        }
        catch (IOException iOException) {
            if (this.closed) {
                return -1;
            }
            throw iOException;
        }
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        this.raf.close();
    }
}

