/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import java.io.Serializable;
import java.util.Map;

public class PublishRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String topicArn;
    private String targetArn;
    private String phoneNumber;
    private String message;
    private String subject;
    private String messageStructure;
    private SdkInternalMap<String, MessageAttributeValue> messageAttributes;

    public PublishRequest() {
    }

    public PublishRequest(String topicArn, String message) {
        this.setTopicArn(topicArn);
        this.setMessage(message);
    }

    public PublishRequest(String topicArn, String message, String subject) {
        this.setTopicArn(topicArn);
        this.setMessage(message);
        this.setSubject(subject);
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public PublishRequest withTopicArn(String topicArn) {
        this.setTopicArn(topicArn);
        return this;
    }

    public void setTargetArn(String targetArn) {
        this.targetArn = targetArn;
    }

    public String getTargetArn() {
        return this.targetArn;
    }

    public PublishRequest withTargetArn(String targetArn) {
        this.setTargetArn(targetArn);
        return this;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public PublishRequest withPhoneNumber(String phoneNumber) {
        this.setPhoneNumber(phoneNumber);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public PublishRequest withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public PublishRequest withSubject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public String getMessageStructure() {
        return this.messageStructure;
    }

    public PublishRequest withMessageStructure(String messageStructure) {
        this.setMessageStructure(messageStructure);
        return this;
    }

    public Map<String, MessageAttributeValue> getMessageAttributes() {
        if (this.messageAttributes == null) {
            this.messageAttributes = new SdkInternalMap();
        }
        return this.messageAttributes;
    }

    public void setMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.messageAttributes = messageAttributes == null ? null : new SdkInternalMap(messageAttributes);
    }

    public PublishRequest withMessageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
        this.setMessageAttributes(messageAttributes);
        return this;
    }

    public PublishRequest addMessageAttributesEntry(String key, MessageAttributeValue value) {
        if (null == this.messageAttributes) {
            this.messageAttributes = new SdkInternalMap();
        }
        if (this.messageAttributes.containsKey((Object)key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.messageAttributes.put((Object)key, (Object)value);
        return this;
    }

    public PublishRequest clearMessageAttributesEntries() {
        this.messageAttributes = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getTargetArn() != null) {
            sb.append("TargetArn: " + this.getTargetArn() + ",");
        }
        if (this.getPhoneNumber() != null) {
            sb.append("PhoneNumber: " + this.getPhoneNumber() + ",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: " + this.getMessage() + ",");
        }
        if (this.getSubject() != null) {
            sb.append("Subject: " + this.getSubject() + ",");
        }
        if (this.getMessageStructure() != null) {
            sb.append("MessageStructure: " + this.getMessageStructure() + ",");
        }
        if (this.getMessageAttributes() != null) {
            sb.append("MessageAttributes: " + this.getMessageAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getTargetArn() == null ^ this.getTargetArn() == null) {
            return false;
        }
        if (other.getTargetArn() != null && !other.getTargetArn().equals(this.getTargetArn())) {
            return false;
        }
        if (other.getPhoneNumber() == null ^ this.getPhoneNumber() == null) {
            return false;
        }
        if (other.getPhoneNumber() != null && !other.getPhoneNumber().equals(this.getPhoneNumber())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getSubject() == null ^ this.getSubject() == null) {
            return false;
        }
        if (other.getSubject() != null && !other.getSubject().equals(this.getSubject())) {
            return false;
        }
        if (other.getMessageStructure() == null ^ this.getMessageStructure() == null) {
            return false;
        }
        if (other.getMessageStructure() != null && !other.getMessageStructure().equals(this.getMessageStructure())) {
            return false;
        }
        if (other.getMessageAttributes() == null ^ this.getMessageAttributes() == null) {
            return false;
        }
        return other.getMessageAttributes() == null || other.getMessageAttributes().equals(this.getMessageAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetArn() == null ? 0 : this.getTargetArn().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumber() == null ? 0 : this.getPhoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getSubject() == null ? 0 : this.getSubject().hashCode());
        hashCode = 31 * hashCode + (this.getMessageStructure() == null ? 0 : this.getMessageStructure().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAttributes() == null ? 0 : this.getMessageAttributes().hashCode());
        return hashCode;
    }

    public PublishRequest clone() {
        return (PublishRequest)super.clone();
    }
}

