/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import java.io.Serializable;
import java.util.ArrayList;

public class LogGroupData
implements Serializable {
    private static final long serialVersionUID = -7939302281903476332L;
    protected String mReserved = "";
    protected String mTopic = "";
    protected String mSource = "";
    protected String mMachineUUID = "";
    protected ArrayList<LogItem> mLogs = new ArrayList();

    public LogGroupData() {
    }

    public LogGroupData(String reserved, String topic, String source, String mMachineUUID, ArrayList<LogItem> logs) {
        this.mReserved = reserved;
        this.mTopic = topic;
        this.mSource = source;
        this.SetAllLogs(logs);
    }

    public LogGroupData(LogGroupData logGroup) {
        this.mReserved = logGroup.GetReserved();
        this.mTopic = logGroup.GetTopic();
        this.mSource = logGroup.GetSource();
        this.mMachineUUID = logGroup.GetMachineUUID();
        this.SetAllLogs(logGroup.GetAllLogs());
    }

    public ArrayList<LogItem> GetAllLogs() {
        return this.mLogs;
    }

    public LogItem GetLogByIndex(int index) {
        return this.mLogs.get(index);
    }

    public void SetAllLogs(ArrayList<LogItem> logs) {
        this.mLogs = new ArrayList();
        for (LogItem originLog : logs) {
            LogItem log = new LogItem();
            log.mLogTime = originLog.mLogTime;
            for (LogContent originContent : originLog.mContents) {
                LogContent content = new LogContent();
                content.mKey = originContent.mKey;
                content.mValue = originContent.mValue;
                log.mContents.add(content);
            }
            this.mLogs.add(log);
        }
    }

    public String GetReserved() {
        return this.mReserved;
    }

    public void SetReserved(String reserved) {
        this.mReserved = reserved;
    }

    public String GetTopic() {
        return this.mTopic;
    }

    public void SetTopic(String topic) {
        this.mTopic = topic;
    }

    public String GetSource() {
        return this.mSource;
    }

    public void SetSource(String source) {
        this.mSource = source;
    }

    public String GetMachineUUID() {
        return this.mMachineUUID;
    }

    public void SetMachineUUID(String machineUUID) {
        this.mMachineUUID = machineUUID;
    }
}

