/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class IndexKey
implements Serializable {
    private static final long serialVersionUID = -6607480102839653253L;
    private List<String> token = new ArrayList<String>();
    private boolean caseSensitive;

    public IndexKey() {
    }

    public IndexKey(List<String> token, boolean caseSensitive) {
        this.SetToken(token);
        this.caseSensitive = caseSensitive;
    }

    public IndexKey(IndexKey other) {
        this.SetToken(other.GetToken());
        this.caseSensitive = other.GetCaseSensitive();
    }

    public List<String> GetToken() {
        return this.token;
    }

    public boolean GetCaseSensitive() {
        return this.caseSensitive;
    }

    public void SetToken(List<String> token) {
        this.token = new ArrayList<String>(token);
    }

    public void SetCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject allKeys = new JSONObject();
        JSONArray tokenDict = new JSONArray();
        for (String v : this.token) {
            tokenDict.add((Object)v);
        }
        allKeys.put((Object)"token", (Object)tokenDict);
        allKeys.put((Object)"caseSensitive", (Object)this.GetCaseSensitive());
        return allKeys;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject allKeys = this.ToRequestJson();
        return allKeys;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.SetCaseSensitive(dict.getBoolean("caseSensitive"));
            JSONArray tokenDict = dict.getJSONArray("token");
            this.token = new ArrayList<String>();
            int i = 0;
            while (i < tokenDict.size()) {
                this.token.add(tokenDict.getString(i));
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKey", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexKeyString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)indexKeyString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKey", e.getMessage(), e, "");
        }
    }
}

