/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log;

import com.aliyun.openservices.log.LogService;
import com.aliyun.openservices.log.common.Config;
import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.log.common.ConsumerGroup;
import com.aliyun.openservices.log.common.Histogram;
import com.aliyun.openservices.log.common.Index;
import com.aliyun.openservices.log.common.LZ4Encoder;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.LogStore;
import com.aliyun.openservices.log.common.Logs;
import com.aliyun.openservices.log.common.Machine;
import com.aliyun.openservices.log.common.MachineGroup;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.common.ShipperTask;
import com.aliyun.openservices.log.common.ShipperTasksStatistic;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.openservices.log.http.client.ClientException;
import com.aliyun.openservices.log.http.client.HttpMethod;
import com.aliyun.openservices.log.http.client.ServiceException;
import com.aliyun.openservices.log.http.comm.DefaultServiceClient;
import com.aliyun.openservices.log.http.comm.RequestMessage;
import com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.aliyun.openservices.log.http.comm.ServiceClient;
import com.aliyun.openservices.log.http.utils.CodingUtils;
import com.aliyun.openservices.log.http.utils.DateUtil;
import com.aliyun.openservices.log.request.ApplyConfigToMachineGroupRequest;
import com.aliyun.openservices.log.request.BatchGetLogRequest;
import com.aliyun.openservices.log.request.ConsumerGroupGetCheckPointRequest;
import com.aliyun.openservices.log.request.ConsumerGroupHeartBeatRequest;
import com.aliyun.openservices.log.request.ConsumerGroupUpdateCheckPointRequest;
import com.aliyun.openservices.log.request.CreateConfigRequest;
import com.aliyun.openservices.log.request.CreateConsumerGroupRequest;
import com.aliyun.openservices.log.request.CreateIndexRequest;
import com.aliyun.openservices.log.request.CreateLogStoreRequest;
import com.aliyun.openservices.log.request.CreateMachineGroupRequest;
import com.aliyun.openservices.log.request.DeleteConfigRequest;
import com.aliyun.openservices.log.request.DeleteIndexRequest;
import com.aliyun.openservices.log.request.DeleteLogStoreRequest;
import com.aliyun.openservices.log.request.DeleteMachineGroupRequest;
import com.aliyun.openservices.log.request.DeleteShardRequest;
import com.aliyun.openservices.log.request.GetAppliedConfigsRequest;
import com.aliyun.openservices.log.request.GetAppliedMachineGroupRequest;
import com.aliyun.openservices.log.request.GetConfigRequest;
import com.aliyun.openservices.log.request.GetCursorRequest;
import com.aliyun.openservices.log.request.GetHistogramsRequest;
import com.aliyun.openservices.log.request.GetIndexRequest;
import com.aliyun.openservices.log.request.GetLogStoreRequest;
import com.aliyun.openservices.log.request.GetLogsRequest;
import com.aliyun.openservices.log.request.GetMachineGroupRequest;
import com.aliyun.openservices.log.request.ListConfigRequest;
import com.aliyun.openservices.log.request.ListLogStoresRequest;
import com.aliyun.openservices.log.request.ListMachineGroupRequest;
import com.aliyun.openservices.log.request.ListShardRequest;
import com.aliyun.openservices.log.request.ListTopicsRequest;
import com.aliyun.openservices.log.request.MergeShardsRequest;
import com.aliyun.openservices.log.request.PutLogsRequest;
import com.aliyun.openservices.log.request.RemoveConfigFromMachineGroupRequest;
import com.aliyun.openservices.log.request.SplitShardRequest;
import com.aliyun.openservices.log.request.UpdateConfigRequest;
import com.aliyun.openservices.log.request.UpdateIndexRequest;
import com.aliyun.openservices.log.request.UpdateLogStoreRequest;
import com.aliyun.openservices.log.request.UpdateMachineGroupRequest;
import com.aliyun.openservices.log.response.ApplyConfigToMachineGroupResponse;
import com.aliyun.openservices.log.response.BatchGetLogResponse;
import com.aliyun.openservices.log.response.ConsumerGroupCheckPointResponse;
import com.aliyun.openservices.log.response.ConsumerGroupHeartBeatResponse;
import com.aliyun.openservices.log.response.ConsumerGroupUpdateCheckPointResponse;
import com.aliyun.openservices.log.response.CreateConfigResponse;
import com.aliyun.openservices.log.response.CreateConsumerGroupResponse;
import com.aliyun.openservices.log.response.CreateIndexResponse;
import com.aliyun.openservices.log.response.CreateLogStoreResponse;
import com.aliyun.openservices.log.response.CreateMachineGroupResponse;
import com.aliyun.openservices.log.response.DeleteConfigResponse;
import com.aliyun.openservices.log.response.DeleteConsumerGroupResponse;
import com.aliyun.openservices.log.response.DeleteIndexResponse;
import com.aliyun.openservices.log.response.DeleteLogStoreResponse;
import com.aliyun.openservices.log.response.DeleteMachineGroupResponse;
import com.aliyun.openservices.log.response.DeleteShardResponse;
import com.aliyun.openservices.log.response.GetAppliedConfigResponse;
import com.aliyun.openservices.log.response.GetAppliedMachineGroupsResponse;
import com.aliyun.openservices.log.response.GetConfigResponse;
import com.aliyun.openservices.log.response.GetCursorResponse;
import com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.aliyun.openservices.log.response.GetIndexResponse;
import com.aliyun.openservices.log.response.GetLogStoreResponse;
import com.aliyun.openservices.log.response.GetLogsResponse;
import com.aliyun.openservices.log.response.GetMachineGroupResponse;
import com.aliyun.openservices.log.response.GetShipperTasksResponse;
import com.aliyun.openservices.log.response.ListConfigResponse;
import com.aliyun.openservices.log.response.ListConsumerGroupResponse;
import com.aliyun.openservices.log.response.ListLogStoresResponse;
import com.aliyun.openservices.log.response.ListMachineGroupResponse;
import com.aliyun.openservices.log.response.ListMachinesResponse;
import com.aliyun.openservices.log.response.ListShardResponse;
import com.aliyun.openservices.log.response.ListShipperResponse;
import com.aliyun.openservices.log.response.ListTopicsResponse;
import com.aliyun.openservices.log.response.PutLogsResponse;
import com.aliyun.openservices.log.response.RemoveConfigFromMachineGroupResponse;
import com.aliyun.openservices.log.response.RetryShipperTasksResponse;
import com.aliyun.openservices.log.response.UpdateConfigResponse;
import com.aliyun.openservices.log.response.UpdateConsumerGroupResponse;
import com.aliyun.openservices.log.response.UpdateIndexResponse;
import com.aliyun.openservices.log.response.UpdateLogStoreResponse;
import com.aliyun.openservices.log.response.UpdateMachineGroupResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.validator.routines.InetAddressValidator;

public class Client
implements LogService {
    private String httpType;
    private String hostName;
    private String accessId;
    private String accessKey;
    private String sourceIp;
    private ServiceClient serviceClient;
    private String securityToken;
    private String realIpForConsole;
    private Boolean useSSLForConsole;
    private String userAgent = "sls-java-sdk-v-0.6.1";

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getRealIpForConsole() {
        return this.realIpForConsole;
    }

    public void setRealIpForConsole(String realIpForConsole) {
        this.realIpForConsole = realIpForConsole;
    }

    public boolean isUseSSLForConsole() {
        return this.useSSLForConsole;
    }

    public void setUseSSLForConsole(boolean useSSLForConsole) {
        this.useSSLForConsole = useSSLForConsole;
    }

    public void ClearConsoleResources() {
        this.realIpForConsole = null;
        this.useSSLForConsole = null;
    }

    public String GetSecurityToken() {
        return this.securityToken;
    }

    public void SetSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void RemoveSecurityToken() {
        this.securityToken = null;
    }

    public Client(String endpoint, String accessId, String accessKey) {
        this(endpoint, accessId, accessKey, Client.GetLocalMachineIp());
    }

    public Client(String endpoint, String accessId, String accessKey, String SourceIp) {
        this(endpoint, accessId, accessKey, SourceIp, true);
    }

    public Client(String endpoint, String accessId, String accessKey, String sourceIp, boolean compressFlag) {
        CodingUtils.assertStringNotNullOrEmpty(endpoint, "endpoint");
        CodingUtils.assertStringNotNullOrEmpty(accessId, "accessId");
        CodingUtils.assertStringNotNullOrEmpty(accessKey, "accessKey");
        if (endpoint.startsWith("http://")) {
            this.hostName = endpoint.substring(7);
            this.httpType = new String("http://");
        } else if (endpoint.startsWith("https://")) {
            this.hostName = endpoint.substring(8);
            this.httpType = new String("https://");
        } else {
            this.hostName = endpoint;
            this.httpType = new String("http://");
        }
        while (this.hostName.endsWith("/")) {
            this.hostName = this.hostName.substring(0, this.hostName.length() - 1);
        }
        if (Client.IsIpAddress(this.hostName)) {
            throw new IllegalArgumentException("EndpontInvalid", new Exception("The ip address is not supported"));
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = Client.GetLocalMachineIp();
        }
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setConnectionTimeout(5000);
        clientConfig.setSocketTimeout(20000);
        this.serviceClient = new DefaultServiceClient(clientConfig);
    }

    private URI GetHostURI(String project) {
        String endPointUrl = String.valueOf(this.httpType) + this.hostName;
        if (project != null && !project.isEmpty()) {
            endPointUrl = String.valueOf(this.httpType) + project + "." + this.hostName;
        }
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("EndpointInvalid", e);
        }
    }

    private static boolean IsIpAddress(String str) {
        Pattern pattern = Pattern.compile("^(\\d{1,3}\\.){3}\\d{1,3}");
        return pattern.matcher(str).matches();
    }

    @Override
    public GetHistogramsResponse GetHistograms(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetHistogramsRequest request = new GetHistogramsRequest(project, logStore, topic, query, from, to);
        return this.GetHistograms(request);
    }

    @Override
    public GetHistogramsResponse GetHistograms(GetHistogramsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + request.GetLogStore() + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray object = this.ParseResponseMessageToArray(response, requestId);
        GetHistogramsResponse hisTogramResponse = new GetHistogramsResponse(resHeaders);
        this.ExtractHistograms(hisTogramResponse, object);
        return hisTogramResponse;
    }

    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source, String shardHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, shardHash);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(String project, String logStore, String topic, List<LogItem> logItems, String source) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(logItems, "logGroup");
        PutLogsRequest request = new PutLogsRequest(project, logStore, topic, source, logItems, null);
        request.SetCompressType(Consts.CompressType.LZ4);
        return this.PutLogs(request);
    }

    @Override
    public PutLogsResponse PutLogs(PutLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String topic = request.GetTopic();
        CodingUtils.assertParameterNotNull(topic, "topic");
        String source = request.GetSource();
        ArrayList<LogItem> logItems = request.GetLogItems();
        String shardKey = request.GetRouteKey();
        Consts.CompressType compressType = request.GetCompressType();
        CodingUtils.assertParameterNotNull((Object)compressType, "compressType");
        if (logItems.size() > 4096) {
            throw new LogException("InvalidLogSize", "logItems' length exceeds maximum limitation : " + String.valueOf(4096) + " lines", "");
        }
        Logs.LogGroup.Builder logs = Logs.LogGroup.newBuilder();
        if (topic != null) {
            logs.setTopic(topic);
        }
        if (source == null || source.isEmpty()) {
            logs.setSource(this.sourceIp);
        } else {
            logs.setSource(source);
        }
        int i = 0;
        while (i < logItems.size()) {
            LogItem item = (LogItem)logItems.get(i);
            Logs.Log.Builder log = logs.addLogsBuilder();
            log.setTime(item.mLogTime);
            for (LogContent content : item.mContents) {
                Logs.Log.Content.Builder contentBuilder = log.addContentsBuilder();
                contentBuilder.setKey(content.mKey);
                contentBuilder.setValue(content.mValue);
            }
            ++i;
        }
        byte[] logBytes = logs.build().toByteArray();
        if (logBytes.length > 0x300000) {
            throw new LogException("InvalidLogSize", "logItems' size exceeds maximum limitation : " + String.valueOf(0x300000) + " bytes", "");
        }
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        long orignalSize = logBytes.length;
        if (compressType == Consts.CompressType.LZ4) {
            logBytes = LZ4Encoder.compressToLhLz4Chunk((byte[])logBytes.clone());
            headParameter.put("x-log-compresstype", compressType.toString());
        } else if (compressType == Consts.CompressType.GZIP) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(logBytes.length);
            Deflater compresser = new Deflater();
            compresser.setInput(logBytes);
            compresser.finish();
            byte[] buf = new byte[10240];
            while (!compresser.finished()) {
                int count = compresser.deflate(buf);
                out.write(buf, 0, count);
            }
            logBytes = out.toByteArray();
            headParameter.put("x-log-compresstype", compressType.toString());
        }
        headParameter.put("x-log-bodyrawsize", String.valueOf(orignalSize));
        String resourceUri = "/logstores/" + logStore;
        resourceUri = shardKey == null || shardKey.length() == 0 ? String.valueOf(resourceUri) + "/shards/lb" : String.valueOf(resourceUri) + "/shards/route?key=" + shardKey;
        HashMap<String, String> urlParameter = new HashMap();
        urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, logBytes);
        Map<String, String> resHeaders = response.getHeaders();
        PutLogsResponse putLogsResponse = new PutLogsResponse(resHeaders);
        return putLogsResponse;
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(String project, String logStore, int from, int to, String topic, String query, int line, int offset, boolean reverse) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(topic, "topic");
        CodingUtils.assertParameterNotNull(query, "query");
        GetLogsRequest request = new GetLogsRequest(project, logStore, from, to, topic, query, offset, line, reverse);
        return this.GetLogs(request);
    }

    @Override
    public GetLogsResponse GetLogs(GetLogsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.GetLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray object = this.ParseResponseMessageToArray(response, requestId);
        GetLogsResponse getLogsResponse = new GetLogsResponse(resHeaders);
        this.ExtractLogs(getLogsResponse, object);
        return getLogsResponse;
    }

    @Override
    public ListLogStoresResponse ListLogStores(String project, int offset, int size, String logstoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ListLogStoresRequest request = new ListLogStoresRequest(project, offset, size, logstoreName);
        return this.ListLogStores(request);
    }

    @Override
    public ListLogStoresResponse ListLogStores(ListLogStoresRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores";
        String project = request.GetProject();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        ListLogStoresResponse listLogStoresResponse = new ListLogStoresResponse(resHeaders);
        listLogStoresResponse.SetLogStores(this.ExtractJsonArray("logstores", object));
        listLogStoresResponse.SetTotal(this.ExtractJsonInteger("total", object));
        return listLogStoresResponse;
    }

    @Override
    public ListTopicsResponse ListTopics(String project, String logStore, String token, int line) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(token, "token");
        ListTopicsRequest request = new ListTopicsRequest(project, logStore, token, line);
        return this.ListTopics(request);
    }

    @Override
    public ListTopicsResponse ListTopics(ListTopicsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        Map<String, String> urlParameter = request.GetAllParams();
        String project = request.GetProject();
        String logStore = request.GetLogStore();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/logstores/" + logStore + "/index";
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray json_array = this.ParseResponseMessageToArray(response, requestId);
        ListTopicsResponse listTopicRespone = new ListTopicsResponse(resHeaders);
        ArrayList<String> string_array = new ArrayList<String>();
        int index = 0;
        while (index < json_array.size()) {
            string_array.add(json_array.getString(index));
            ++index;
        }
        listTopicRespone.SetTopics(string_array);
        return listTopicRespone;
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, long fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, fromTime);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStore, int shardId, Date fromTime) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStream");
        CodingUtils.assertParameterNotNull(fromTime, "fromTime");
        long timeStamp = fromTime.getTime() / 1000L;
        GetCursorRequest request = new GetCursorRequest(project, logStore, shardId, timeStamp);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(String project, String logStream, int shardId, Consts.CursorMode mode) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStream, "logStream");
        GetCursorRequest request = new GetCursorRequest(project, logStream, shardId, mode);
        return this.GetCursor(request);
    }

    @Override
    public GetCursorResponse GetCursor(GetCursorRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardId = String.valueOf(request.GetShardId());
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards/").append(shardId);
        String resourceUri = resourceUriBuilder.toString();
        headParameter.put("Content-Length", String.valueOf(0));
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        GetCursorResponse getCursorResponse = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            JSONObject object = this.ParserResponseMessage(response, requestId);
            getCursorResponse = new GetCursorResponse(resHeaders, object.getString("cursor"));
        }
        catch (JSONException e) {
            throw new LogException("FailToCreateCursor", e.getMessage(), e, this.GetRequestId(response.getHeaders()));
        }
        return getCursorResponse;
    }

    @Override
    public ListShardResponse SplitShard(String prj, String logStore, int shardId, String midHash) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(prj, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        CodingUtils.assertStringNotNullOrEmpty(midHash, "midHash");
        return this.SplitShard(new SplitShardRequest(prj, logStore, shardId, midHash));
    }

    @Override
    public ListShardResponse SplitShard(SplitShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        String midHash = request.GetMidHash();
        CodingUtils.assertStringNotNullOrEmpty(midHash, "midHashKey");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards/").append(shardId);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        String requestId = "";
        JSONArray array = null;
        ResponseMessage response = new ResponseMessage();
        ListShardResponse listShardResponse = null;
        response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        requestId = this.GetRequestId(resHeaders);
        ArrayList<Shard> shards = new ArrayList();
        array = this.ParseResponseMessageToArray(response, requestId);
        shards = this.ExtractShards(array, requestId);
        listShardResponse = new ListShardResponse(resHeaders, shards);
        return listShardResponse;
    }

    @Override
    public ListShardResponse MergeShards(String prj, String logStore, int shardId) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(prj, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        return this.MergeShards(new MergeShardsRequest(prj, logStore, shardId));
    }

    @Override
    public ListShardResponse MergeShards(MergeShardsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards/").append(shardId);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        String requestId = "";
        JSONArray array = null;
        ResponseMessage response = new ResponseMessage();
        ListShardResponse listShardResponse = null;
        response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        requestId = this.GetRequestId(resHeaders);
        ArrayList<Shard> shards = new ArrayList();
        array = this.ParseResponseMessageToArray(response, requestId);
        shards = this.ExtractShards(array, requestId);
        listShardResponse = new ListShardResponse(resHeaders, shards);
        return listShardResponse;
    }

    @Override
    public DeleteShardResponse DeleteShard(String prj, String logStore, int shardId) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(prj, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "shardId");
        return this.DeleteShard(new DeleteShardRequest(prj, logStore, shardId));
    }

    @Override
    public DeleteShardResponse DeleteShard(DeleteShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        int shardId = request.GetShardId();
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards/").append(shardId);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        DeleteShardResponse res = new DeleteShardResponse(resHeaders);
        return res;
    }

    @Override
    public ListShardResponse ListShard(String prj, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(prj, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.ListShard(new ListShardRequest(prj, logStore));
    }

    @Override
    public ListShardResponse ListShard(ListShardRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards");
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        String requestId = "";
        JSONArray array = null;
        ResponseMessage response = new ResponseMessage();
        ListShardResponse listShardResponse = null;
        response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        requestId = this.GetRequestId(resHeaders);
        ArrayList<Shard> shards = new ArrayList();
        array = this.ParseResponseMessageToArray(response, requestId);
        shards = this.ExtractShards(array, requestId);
        listShardResponse = new ListShardResponse(resHeaders, shards);
        return listShardResponse;
    }

    protected String GetRequestId(Map<String, String> headers) {
        if (headers.containsKey("x-log-requestid")) {
            return headers.get("x-log-requestid");
        }
        return "";
    }

    @Override
    public BatchGetLogResponse BatchGetLog(String project, String logStore, int shardId, int count, String cursor) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.BatchGetLog(new BatchGetLogRequest(project, logStore, shardId, count, cursor));
    }

    @Override
    public BatchGetLogResponse BatchGetLog(BatchGetLogRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String shardId = String.valueOf(request.GetShardId());
        CodingUtils.assertStringNotNullOrEmpty(shardId, "shardId");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shards/").append(shardId);
        String resourceUri = resourceUriBuilder.toString();
        headParameter.put("Accept-Encoding", "lz4");
        headParameter.put("accept", "application/x-protobuf");
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        BatchGetLogResponse batchGetLogResponse = null;
        response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        byte[] rawData = response.GetRawBody();
        batchGetLogResponse = new BatchGetLogResponse(resHeaders, rawData);
        return batchGetLogResponse;
    }

    @Override
    public CreateConfigResponse CreateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.CreateConfig(new CreateConfigRequest(project, config));
    }

    @Override
    public CreateConfigResponse CreateConfig(CreateConfigRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = config.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/configs";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = new ResponseMessage();
        CreateConfigResponse createConfigResponse = null;
        response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        createConfigResponse = new CreateConfigResponse(resHeaders);
        return createConfigResponse;
    }

    @Override
    public UpdateConfigResponse UpdateConfig(String project, Config config) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(config, "config");
        return this.UpdateConfig(new UpdateConfigRequest(project, config));
    }

    @Override
    public UpdateConfigResponse UpdateConfig(UpdateConfigRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Config config = request.GetConfig();
        CodingUtils.assertParameterNotNull(config, "config");
        String configName = config.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = config.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/configs/").append(configName);
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = new ResponseMessage();
        UpdateConfigResponse updateConfigResponse = null;
        response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        updateConfigResponse = new UpdateConfigResponse(resHeaders);
        return updateConfigResponse;
    }

    protected Config ExtractConfigFromResponse(JSONObject dict, String requestId) throws LogException {
        Config config = new Config();
        try {
            config.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return config;
    }

    @Override
    public GetConfigResponse GetConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetConfig(new GetConfigRequest(project, configName));
    }

    @Override
    public GetConfigResponse GetConfig(GetConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/configs/").append(configName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        GetConfigResponse getConfigResponse = null;
        response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        Config config = null;
        config = this.ExtractConfigFromResponse(object, requestId);
        getConfigResponse = new GetConfigResponse(resHeaders, config);
        return getConfigResponse;
    }

    @Override
    public DeleteConfigResponse DeleteConfig(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.DeleteConfig(new DeleteConfigRequest(project, configName));
    }

    @Override
    public DeleteConfigResponse DeleteConfig(DeleteConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/configs/").append(configName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConfigResponse(resHeaders);
    }

    protected List<String> ExtractConfigs(JSONObject object, String requestId) throws LogException {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("configs");
            int i = 0;
            while (i < array.size()) {
                String configName = array.getString(i);
                configs.add(configName);
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json array string : " + array.toString(), e, requestId);
        }
        return configs;
    }

    @Override
    public ListConfigResponse ListConfig(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project));
    }

    @Override
    public ListConfigResponse ListConfig(String project, int offSet, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListConfig(new ListConfigRequest(project, offSet, size));
    }

    @Override
    public ListConfigResponse ListConfig(String project, String configName, int offSet, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ListConfig(new ListConfigRequest(project, configName, offSet, size));
    }

    @Override
    public ListConfigResponse ListConfig(ListConfigRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/configs";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListConfigResponse listConfigResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.ParserResponseMessage(response, requestId);
            int total = 0;
            int count = 0;
            ArrayList<String> configs = new ArrayList();
            total = object.getInt("total");
            count = object.getInt("count");
            configs = this.ExtractConfigs(object, requestId);
            listConfigResponse = new ListConfigResponse(resHeaders, count, total, configs);
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid list config json string : " + object.toString(), e, this.GetRequestId(response.getHeaders()));
        }
        return listConfigResponse;
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.CreateMachineGroup(new CreateMachineGroupRequest(project, group));
    }

    @Override
    public CreateMachineGroupResponse CreateMachineGroup(CreateMachineGroupRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = group.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/machinegroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateMachineGroupResponse(resHeaders);
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(String project, MachineGroup group) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(group, "group");
        return this.UpdateMachineGroup(new UpdateMachineGroupRequest(project, group));
    }

    @Override
    public UpdateMachineGroupResponse UpdateMachineGroup(UpdateMachineGroupRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        MachineGroup group = request.GetMachineGroup();
        CodingUtils.assertParameterNotNull(group, "group");
        String groupName = group.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = group.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName);
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateMachineGroupResponse(resHeaders);
    }

    protected MachineGroup ExtractMachineGroupFromResponse(JSONObject dict, String requestId) throws LogException {
        MachineGroup group = new MachineGroup();
        try {
            group.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return group;
    }

    protected ArrayList<String> ExtractConfigsFromResponse(JSONObject object, String requestId) throws LogException {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray configobj = object.getJSONArray("configs");
        int i = 0;
        while (i < configobj.size()) {
            configs.add(configobj.getString(i));
            ++i;
        }
        return configs;
    }

    protected ArrayList<String> ExtractConfigMachineGroupFromResponse(JSONObject object, String requestId) throws LogException {
        ArrayList<String> configs = new ArrayList<String>();
        JSONArray configobj = object.getJSONArray("machinegroups");
        int i = 0;
        while (i < configobj.size()) {
            configs.add(configobj.getString(i));
            ++i;
        }
        return configs;
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetAppliedConfig(new GetAppliedConfigsRequest(project, groupName));
    }

    @Override
    public GetAppliedConfigResponse GetAppliedConfig(GetAppliedConfigsRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName).append("/configs");
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        ArrayList<String> group = null;
        group = this.ExtractConfigsFromResponse(object, requestId);
        return new GetAppliedConfigResponse(resHeaders, group);
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(String project, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.GetAppliedMachineGroups(new GetAppliedMachineGroupRequest(project, configName));
    }

    @Override
    public GetAppliedMachineGroupsResponse GetAppliedMachineGroups(GetAppliedMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/configs/").append(configName).append("/machinegroups");
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        ArrayList<String> group = null;
        group = this.ExtractConfigMachineGroupFromResponse(object, requestId);
        return new GetAppliedMachineGroupsResponse(resHeaders, group);
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.GetMachineGroup(new GetMachineGroupRequest(project, groupName));
    }

    @Override
    public GetMachineGroupResponse GetMachineGroup(GetMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        GetMachineGroupResponse getMachineGroupResponse = null;
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        MachineGroup group = this.ExtractMachineGroupFromResponse(object, requestId);
        getMachineGroupResponse = new GetMachineGroupResponse(resHeaders, group);
        return getMachineGroupResponse;
    }

    @Override
    public ListMachinesResponse ListMachines(String project, String machineGroup, int offset, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(machineGroup, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(machineGroup).append("/machines");
        String resourceUri = resourceUriBuilder.toString();
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        return this.ExtructMachinesFromResponse(resHeaders, object);
    }

    private ListMachinesResponse ExtructMachinesFromResponse(Map<String, String> resHeaders, JSONObject dict) throws LogException {
        try {
            int count = dict.getInt("count");
            int total = dict.getInt("total");
            JSONArray array = dict.getJSONArray("machines");
            ArrayList<Machine> machines = new ArrayList<Machine>();
            int i = 0;
            while (i < array.size()) {
                JSONObject machine_obj = array.getJSONObject(i);
                Machine machine = new Machine();
                machine.FromJsonObject(machine_obj);
                machines.add(machine);
                ++i;
            }
            return new ListMachinesResponse(resHeaders, count, total, machines);
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), this.GetRequestId(resHeaders));
        }
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(String project, String groupName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.DeleteMachineGroup(new DeleteMachineGroupRequest(project, groupName));
    }

    @Override
    public DeleteMachineGroupResponse DeleteMachineGroup(DeleteMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteMachineGroupResponse(resHeaders);
    }

    protected List<String> ExtractMachineGroups(JSONObject object, String requestId) throws LogException {
        ArrayList<String> machineGroups = new ArrayList<String>();
        JSONArray array = new JSONArray();
        try {
            array = object.getJSONArray("machinegroups");
            int i = 0;
            while (i < array.size()) {
                String groupName = array.getString(i);
                machineGroups.add(groupName);
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid machine group json array string : " + array.toString(), e, requestId);
        }
        return machineGroups;
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, int offSet, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, offSet, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(String project, String groupName, int offSet, int size) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        return this.ListMachineGroup(new ListMachineGroupRequest(project, groupName, offSet, size));
    }

    @Override
    public ListMachineGroupResponse ListMachineGroup(ListMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String resourceUri = "/machinegroups";
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = new ResponseMessage();
        ListMachineGroupResponse listMachineGroupResponse = null;
        JSONObject object = null;
        try {
            response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
            Map<String, String> resHeaders = response.getHeaders();
            String requestId = this.GetRequestId(resHeaders);
            object = this.ParserResponseMessage(response, requestId);
            int total = 0;
            int count = 0;
            ArrayList<String> groups = new ArrayList();
            total = object.getInt("total");
            count = object.getInt("count");
            groups = this.ExtractMachineGroups(object, requestId);
            listMachineGroupResponse = new ListMachineGroupResponse(resHeaders, count, total, groups);
        }
        catch (LogException e) {
            throw e;
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid config json string : " + object.toString(), e, this.GetRequestId(response.getHeaders()));
        }
        return listMachineGroupResponse;
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.ApplyConfigToMachineGroup(new ApplyConfigToMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public ApplyConfigToMachineGroupResponse ApplyConfigToMachineGroup(ApplyConfigToMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName).append("/configs/").append(configName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new ApplyConfigToMachineGroupResponse(resHeaders);
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(String project, String groupName, String configName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        return this.RemoveConfigFromMachineGroup(new RemoveConfigFromMachineGroupRequest(project, groupName, configName));
    }

    @Override
    public RemoveConfigFromMachineGroupResponse RemoveConfigFromMachineGroup(RemoveConfigFromMachineGroupRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String groupName = request.GetGroupName();
        CodingUtils.assertStringNotNullOrEmpty(groupName, "groupName");
        String configName = request.GetConfigName();
        CodingUtils.assertStringNotNullOrEmpty(configName, "configName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/machinegroups/").append(groupName).append("/configs/").append(configName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new RemoveConfigFromMachineGroupResponse(resHeaders);
    }

    private String ExtractJsonString(String nodeKey, JSONObject object) {
        try {
            return object.getString(nodeKey);
        }
        catch (JSONException jSONException) {
            return "";
        }
    }

    private int ExtractJsonInteger(String nodeKey, JSONObject object) {
        try {
            return object.getInt(nodeKey);
        }
        catch (JSONException jSONException) {
            return -1;
        }
    }

    private List<String> ExtractJsonArray(String nodeKey, JSONObject object) {
        try {
            JSONArray items = object.getJSONArray(nodeKey);
            return this.ExtractJsonArray(items);
        }
        catch (JSONException e) {
            return new ArrayList<String>();
        }
    }

    private List<String> ExtractJsonArray(JSONArray ojbect) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            int i = 0;
            while (i < ojbect.size()) {
                result.add(ojbect.getString(i));
                ++i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return result;
    }

    private void ExtractHistograms(GetHistogramsResponse response, JSONArray items) {
        try {
            int i = 0;
            while (i < items.size()) {
                JSONObject item = items.getJSONObject(i);
                Histogram histogram = new Histogram(item.getInt("from"), item.getInt("to"), item.getLong("count"), item.getString("progress"));
                response.AddHistogram(histogram);
                ++i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void ExtractLogs(GetLogsResponse response, JSONArray logs) {
        try {
            int i = 0;
            while (i < logs.size()) {
                JSONObject log = logs.getJSONObject(i);
                String source = new String();
                LogItem logItem = new LogItem();
                Iterator it = log.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = log.getString(key);
                    if (key.equals("__source__")) {
                        source = value;
                        continue;
                    }
                    if (key.equals("__time__")) {
                        logItem.mLogTime = Integer.parseInt(value);
                        continue;
                    }
                    logItem.PushBack(key, value);
                }
                response.AddLog(new QueriedLog(source, logItem));
                ++i;
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected void ErrorCheck(JSONObject object, String requestId) throws LogException {
        if (object.containsKey((Object)"errorCode")) {
            try {
                String errorCode = object.getString("errorCode");
                String errorMessage = object.getString("errorMessage");
                throw new LogException(errorCode, errorMessage, requestId);
            }
            catch (JSONException e) {
                throw new LogException("InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
            }
        }
        throw new LogException("InvalidErrorResponse", "Error response is not a valid error json : \n" + object.toString(), requestId);
    }

    private void ExtractResponseBody(ResponseMessage response) throws LogException {
        InputStream in = response.getContent();
        if (in == null) {
            return;
        }
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        String requestId = this.GetRequestId(response.getHeaders());
        try {
            int ch;
            while ((ch = in.read()) != -1) {
                bytestream.write(ch);
            }
        }
        catch (IOException e) {
            throw new LogException("BadResponse", "Io exception happened when parse the response data : ", e, requestId);
        }
        response.SetBody(bytestream.toByteArray());
    }

    protected JSONObject ParserResponseMessage(ResponseMessage response, String requestId) throws LogException {
        String res;
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LogException("BadResponse", "The response body is null", null, requestId);
        }
        try {
            res = new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("BadResponse", "The response is not valid utf-8 string : ", e, requestId);
        }
        try {
            JSONObject object = JSONObject.fromObject((Object)res);
            return object;
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + res, e, requestId);
        }
    }

    private JSONArray ParseResponseMessageToArray(ResponseMessage response, String requestId) throws LogException {
        String returnStr;
        byte[] body = response.GetRawBody();
        if (body == null) {
            throw new LogException("BadResponse", "The response body is null", null, requestId);
        }
        try {
            returnStr = new String(body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("BadResponse", "The response is not valid utf-8 string : ", e, requestId);
        }
        try {
            JSONArray array = JSONArray.fromObject((Object)returnStr);
            return array;
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid json string : " + returnStr, e, requestId);
        }
    }

    private String GetMd5Value(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String res = new BigInteger(1, md.digest(bytes)).toString(16).toUpperCase();
            StringBuilder zeros = new StringBuilder();
            int i = 0;
            while (i + res.length() < 32) {
                zeros.append("0");
                ++i;
            }
            return String.valueOf(zeros.toString()) + res;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method MD5", e);
        }
    }

    private Map<String, String> GetCommonHeadPara(String project) {
        HashMap<String, String> headParameter = new HashMap<String, String>();
        headParameter.put("User-Agent", this.userAgent);
        headParameter.put("Content-Length", "0");
        headParameter.put("x-log-bodyrawsize", "0");
        headParameter.put("Content-Type", "application/x-protobuf");
        headParameter.put("Date", DateUtil.formatRfc822Date(new Date()));
        if (!project.isEmpty() && project != "") {
            headParameter.put("Host", String.valueOf(project) + "." + this.hostName);
        } else {
            headParameter.put("Host", this.hostName);
        }
        headParameter.put("x-log-apiversion", "0.6.0");
        headParameter.put("x-log-signaturemethod", "hmac-sha1");
        if (this.securityToken != null && !this.securityToken.isEmpty()) {
            headParameter.put("x-acs-security-token", this.securityToken);
        }
        if (this.realIpForConsole != null && !this.realIpForConsole.isEmpty()) {
            headParameter.put("x-log-ip", this.realIpForConsole);
        }
        if (this.useSSLForConsole != null) {
            headParameter.put("x-log-ssl", this.useSSLForConsole != false ? "true" : "false");
        }
        return headParameter;
    }

    private ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> urlParams, Map<String, String> headParams) throws LogException {
        return this.SendData(project, method, resourceUri, urlParams, headParams, new byte[0]);
    }

    protected ResponseMessage SendData(String project, HttpMethod method, String resourceUri, Map<String, String> parameters, Map<String, String> headers, byte[] body) throws LogException {
        if (body.length > 0) {
            headers.put("Content-MD5", this.GetMd5Value(body));
        }
        headers.put("Content-Length", String.valueOf(body.length));
        this.GetSignature(this.accessId, this.accessKey, method.toString(), headers, resourceUri, parameters);
        RequestMessage request = Client.BuildRequest(this.GetHostURI(project), method, resourceUri, parameters, headers, new ByteArrayInputStream(body), body.length);
        ResponseMessage response = null;
        try {
            try {
                response = this.serviceClient.sendRequest(request, "UTF-8");
                this.ExtractResponseBody(response);
                int statusCode = response.getStatusCode();
                if (statusCode != 200) {
                    String requestId = this.GetRequestId(response.getHeaders());
                    JSONObject object = this.ParserResponseMessage(response, requestId);
                    this.ErrorCheck(object, requestId);
                }
            }
            catch (ServiceException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
            catch (ClientException e) {
                throw new LogException("RequestError", "Web request failed: " + e.getMessage(), e, "");
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        return response;
    }

    private static RequestMessage BuildRequest(URI endpoint, HttpMethod httpMethod, String resourceUri, Map<String, String> parameters, Map<String, String> headers, InputStream content, long size) {
        RequestMessage request = new RequestMessage();
        request.setMethod(httpMethod);
        request.setEndpoint(endpoint);
        request.setResourcePath(resourceUri);
        request.setParameters(parameters);
        request.setHeaders(headers);
        request.setContent(content);
        request.setContentLength(size);
        return request;
    }

    private String BuildUrlParameter(Map<String, String> paras) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(paras);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("&");
            }
            builder.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private String GetMapValue(Map<String, String> map, String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return "";
    }

    private String GetCanonicalizedHeaders(Map<String, String> headers) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(headers);
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-log-") && !((String)entry.getKey()).startsWith("x-acs-")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("\n");
            }
            builder.append((String)entry.getKey()).append(":").append((String)entry.getValue());
        }
        return builder.toString();
    }

    private void GetSignature(String accessid, String accesskey, String verb, Map<String, String> headers, String resourceUri, Map<String, String> urlParams) {
        StringBuilder builder = new StringBuilder();
        builder.append(verb).append("\n");
        builder.append(this.GetMapValue(headers, "Content-MD5")).append("\n");
        builder.append(this.GetMapValue(headers, "Content-Type")).append("\n");
        builder.append(this.GetMapValue(headers, "Date")).append("\n");
        builder.append(this.GetCanonicalizedHeaders(headers)).append("\n");
        builder.append(resourceUri);
        if (!urlParams.isEmpty()) {
            builder.append("?");
            builder.append(this.BuildUrlParameter(urlParams));
        }
        String signature = Client.GetSignature(accesskey, builder.toString());
        headers.put("Authorization", "LOG " + accessid + ":" + signature);
    }

    private static String GetSignature(String accesskey, String data) {
        try {
            byte[] keyBytes = accesskey.getBytes("UTF-8");
            byte[] dataBytes = data.getBytes("UTF-8");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(keyBytes, "HmacSHA1"));
            String sig = new String(Base64.encodeBase64((byte[])mac.doFinal(dataBytes)));
            return sig;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not Supported encoding method UTF-8", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Not Supported signature method hmac-sha1", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Failed to calcuate the signature", e);
        }
    }

    private static String GetLocalMachineIp() {
        InetAddressValidator validator = new InetAddressValidator();
        String candidate = new String();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                if (!iface.isUp()) continue;
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String ipAddress;
                    InetAddress address = addresses.nextElement();
                    if (address.isLinkLocalAddress() || address.getHostAddress() == null || (ipAddress = address.getHostAddress()).equals("127.0.0.1")) continue;
                    if (validator.isValidInet4Address(ipAddress)) {
                        return ipAddress;
                    }
                    if (!validator.isValid(ipAddress)) continue;
                    candidate = ipAddress;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return candidate;
    }

    protected ArrayList<Shard> ExtractShards(JSONArray array, String requestId) throws LogException {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        try {
            int i = 0;
            while (i < array.size()) {
                JSONObject shardDict = array.getJSONObject(i);
                int shardId = shardDict.getInt("shardID");
                String status = shardDict.getString("status");
                String begin = shardDict.getString("inclusiveBeginKey");
                String end = shardDict.getString("exclusiveEndKey");
                int createTime = shardDict.getInt("createTime");
                Shard shard = new Shard(shardId, status, begin, end, createTime);
                shards.add(shard);
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString() + e.getMessage(), e, requestId);
        }
        return shards;
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateLogStore(new CreateLogStoreRequest(project, logStore));
    }

    @Override
    public CreateLogStoreResponse CreateLogStore(CreateLogStoreRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = logStore.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateLogStoreResponse(resHeaders);
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.DeleteLogStore(new DeleteLogStoreRequest(project, logStoreName));
    }

    @Override
    public DeleteLogStoreResponse DeleteLogStore(DeleteLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStoreName();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStoreName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteLogStoreResponse(resHeaders);
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(String project, LogStore logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.UpdateLogStore(new UpdateLogStoreRequest(project, logStore));
    }

    @Override
    public UpdateLogStoreResponse UpdateLogStore(UpdateLogStoreRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        LogStore logStore = request.GetLogStore();
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        String logStoreName = logStore.GetLogStoreName();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = logStore.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStoreName);
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateLogStoreResponse(resHeaders);
    }

    @Override
    public GetLogStoreResponse GetLogStore(String project, String logStoreName) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        return this.GetLogStore(new GetLogStoreRequest(project, logStoreName));
    }

    private LogStore ExtractLogStoreFromResponse(JSONObject dict, String requestId) throws LogException {
        LogStore logStore = new LogStore();
        try {
            logStore.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return logStore;
    }

    @Override
    public GetLogStoreResponse GetLogStore(GetLogStoreRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStoreName = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStoreName, "logStoreName");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStoreName);
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        LogStore logStore = this.ExtractLogStoreFromResponse(object, requestId);
        return new GetLogStoreResponse(resHeaders, logStore);
    }

    @Override
    public CreateIndexResponse CreateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.CreateIndex(new CreateIndexRequest(project, logStore, index));
    }

    @Override
    public CreateIndexResponse CreateIndex(CreateIndexRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = index.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/index");
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateIndexResponse(resHeaders);
    }

    @Override
    public UpdateIndexResponse UpdateIndex(String project, String logStore, Index index) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertParameterNotNull(index, "index");
        return this.UpdateIndex(new UpdateIndexRequest(project, logStore, index));
    }

    @Override
    public UpdateIndexResponse UpdateIndex(UpdateIndexRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Index index = request.GetIndex();
        CodingUtils.assertParameterNotNull(index, "index");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = index.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/index");
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateIndexResponse(resHeaders);
    }

    @Override
    public DeleteIndexResponse DeleteIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.DeleteIndex(new DeleteIndexRequest(project, logStore));
    }

    @Override
    public DeleteIndexResponse DeleteIndex(DeleteIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/index");
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteIndexResponse(resHeaders);
    }

    @Override
    public GetIndexResponse GetIndex(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        return this.GetIndex(new GetIndexRequest(project, logStore));
    }

    private Index ExtractIndexFromResponse(JSONObject dict, String requestId) throws LogException {
        Index index = new Index();
        try {
            index.FromJsonString(dict.toString());
        }
        catch (LogException e) {
            throw new LogException(e.GetErrorCode(), e.GetErrorMessage(), e.getCause(), requestId);
        }
        return index;
    }

    @Override
    public GetIndexResponse GetIndex(GetIndexRequest request) throws LogException {
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        String logStore = request.GetLogStore();
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/index");
        String resourceUri = resourceUriBuilder.toString();
        Map<String, String> urlParameter = request.GetAllParams();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        Index index = this.ExtractIndexFromResponse(object, requestId);
        return new GetIndexResponse(resHeaders, index);
    }

    @Override
    public ListShipperResponse ListShipper(String project, String logStore) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shipper");
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        return new ListShipperResponse(resHeaders, this.ExtractJsonInteger("count", object), this.ExtractJsonInteger("total", object), this.ExtractJsonArray("shipper", object));
    }

    @Override
    public GetShipperTasksResponse GetShipperTasks(String project, String logStore, String shipperName, int startTime, int endTime, String statusType, int offset, int size) throws LogException {
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(statusType, "statusType");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shipper/").append(shipperName).append("/tasks");
        String resourceUri = resourceUriBuilder.toString();
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        urlParameter.put("from", String.valueOf(startTime));
        urlParameter.put("to", String.valueOf(endTime));
        urlParameter.put("status", statusType);
        urlParameter.put("offset", String.valueOf(offset));
        urlParameter.put("size", String.valueOf(size));
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONObject object = this.ParserResponseMessage(response, requestId);
        return new GetShipperTasksResponse(resHeaders, this.ExtractJsonInteger("count", object), this.ExtractJsonInteger("total", object), this.ExtractTasksStatisTic(object), this.ExtractShipperTask(object));
    }

    @Override
    public RetryShipperTasksResponse RetryShipperTasks(String project, String logStore, String shipperName, List<String> taskList) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertParameterNotNull(shipperName, "shipperName");
        CodingUtils.assertParameterNotNull(taskList, "taskList");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/shipper/").append(shipperName).append("/tasks");
        String resourceUri = resourceUriBuilder.toString();
        JSONArray array = new JSONArray();
        for (String task : taskList) {
            array.add((Object)task);
        }
        try {
            body = array.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new RetryShipperTasksResponse(resHeaders);
    }

    private ShipperTasksStatistic ExtractTasksStatisTic(JSONObject obj) {
        JSONObject statistic_obj = obj.getJSONObject("statistics");
        return new ShipperTasksStatistic(statistic_obj.getInt("running"), statistic_obj.getInt("success"), statistic_obj.getInt("fail"));
    }

    private List<ShipperTask> ExtractShipperTask(JSONObject object) {
        ArrayList<ShipperTask> res = new ArrayList<ShipperTask>();
        JSONArray array = object.getJSONArray("tasks");
        int i = 0;
        while (i < array.size()) {
            JSONObject item = array.getJSONObject(i);
            ShipperTask task = new ShipperTask();
            task.FromJsonObject(item);
            res.add(task);
            ++i;
        }
        return res;
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(String project, String logStore, ConsumerGroup consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        return this.CreateConsumerGroup(new CreateConsumerGroupRequest(project, logStore, consumerGroup));
    }

    @Override
    public CreateConsumerGroupResponse CreateConsumerGroup(CreateConsumerGroupRequest request) throws LogException {
        byte[] body;
        CodingUtils.assertParameterNotNull(request, "request");
        String project = request.GetProject();
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        ConsumerGroup consumerGroup = request.GetConsumerGroup();
        CodingUtils.assertParameterNotNull(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = consumerGroup.ToRequestString();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + request.GetLogStore() + "/consumergroups";
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new CreateConsumerGroupResponse(resHeaders);
    }

    protected UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, Boolean inOrder, Integer timeoutInSec) throws LogException {
        byte[] body;
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logstore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        String bodyStr = inOrder != null && timeoutInSec != null ? "{\"order\":" + inOrder + ",\"timeout\":" + timeoutInSec + "}" : (inOrder != null ? "{\"order\":" + inOrder + "}" : "{\"timeout\":" + timeoutInSec + "}");
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.PUT, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new UpdateConsumerGroupResponse(resHeaders);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, (Integer)timeoutInSec);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, boolean inOrder) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, (Boolean)inOrder, null);
    }

    @Override
    public UpdateConsumerGroupResponse UpdateConsumerGroup(String project, String logStore, String consumerGroup, int timeoutInSec) throws LogException {
        return this.UpdateConsumerGroup(project, logStore, consumerGroup, null, (Integer)timeoutInSec);
    }

    @Override
    public DeleteConsumerGroupResponse DeleteConsumerGroup(String project, String logStore, String consumerGroup) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertParameterNotNull(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        StringBuilder resourceUriBuilder = new StringBuilder();
        resourceUriBuilder.append("/logstores/").append(logStore).append("/consumergroups/").append(consumerGroup);
        String resourceUri = resourceUriBuilder.toString();
        headParameter.put("Content-Length", String.valueOf(0));
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.DELETE, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        return new DeleteConsumerGroupResponse(resHeaders);
    }

    @Override
    public ListConsumerGroupResponse ListConsumerGroup(String project, String logStore) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        String resourceUri = "/logstores/" + logStore + "/consumergroups";
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        HashMap<String, String> urlParameter = new HashMap<String, String>();
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        ArrayList<ConsumerGroup> consumerGroups = new ArrayList<ConsumerGroup>();
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractConsumerGroups(array, requestId, consumerGroups);
        ListConsumerGroupResponse listConsumerGroupResponse = new ListConsumerGroupResponse(resHeaders);
        listConsumerGroupResponse.SetConsumerGroups(consumerGroups);
        return listConsumerGroupResponse;
    }

    private void ExtractConsumerGroups(JSONArray array, String requestId, ArrayList<ConsumerGroup> consumerGroups) throws LogException {
        try {
            int i = 0;
            while (i < array.size()) {
                JSONObject consumerGroup = array.getJSONObject(i);
                consumerGroups.add(new ConsumerGroup(consumerGroup.getString("name"), consumerGroup.getInt("timeout"), consumerGroup.getBoolean("order")));
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid consumer group json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, consumer, shard, checkpoint, false);
    }

    @Override
    public ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, int shard, String checkpoint) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(checkpoint, "checkpoint");
        return this.UpdateCheckPoint(project, logStore, consumerGroup, "", shard, checkpoint, true);
    }

    protected ConsumerGroupUpdateCheckPointResponse UpdateCheckPoint(String project, String logStore, String consumerGroup, String consumer, int shard, String checkpoint, boolean forceSuccess) throws LogException {
        byte[] body;
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupUpdateCheckPointRequest request = new ConsumerGroupUpdateCheckPointRequest(project, logStore, consumerGroup, consumer, forceSuccess, shard, checkpoint);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        String bodyStr = request.GetRequestBody();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        return new ConsumerGroupUpdateCheckPointResponse(resHeaders);
    }

    @Override
    public ConsumerGroupHeartBeatResponse HeartBeat(String project, String logStore, String consumerGroup, String consumer, ArrayList<Integer> shards) throws LogException {
        byte[] body;
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        CodingUtils.assertStringNotNullOrEmpty(consumer, "consumer");
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        ConsumerGroupHeartBeatRequest request = new ConsumerGroupHeartBeatRequest(project, logStore, consumerGroup, consumer, shards == null ? new ArrayList() : shards);
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        Map<String, String> urlParameter = request.GetAllParams();
        String bodyStr = request.GetRequestBody();
        try {
            body = bodyStr.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage(), "");
        }
        headParameter.put("Content-Type", "application/json");
        ArrayList<Integer> responseShards = new ArrayList<Integer>();
        ResponseMessage response = this.SendData(project, HttpMethod.POST, resourceUri, urlParameter, headParameter, body);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        this.ExtractShards(array, requestId, responseShards);
        return new ConsumerGroupHeartBeatResponse(resHeaders, responseShards);
    }

    protected void ExtractShards(JSONArray array, String requestId, ArrayList<Integer> shards) throws LogException {
        try {
            int i = 0;
            while (i < array.size()) {
                shards.add(array.getInt(i));
                ++i;
            }
        }
        catch (JSONException e) {
            throw new LogException("BadResponse", "The response is not valid shard json array string : " + array.toString(), e, requestId);
        }
    }

    @Override
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup) throws LogException {
        return this.GetCheckPoint(project, logStore, consumerGroup, -1);
    }

    @Override
    public ConsumerGroupCheckPointResponse GetCheckPoint(String project, String logStore, String consumerGroup, int shard) throws LogException {
        CodingUtils.assertStringNotNullOrEmpty(project, "project");
        CodingUtils.assertStringNotNullOrEmpty(logStore, "logStore");
        CodingUtils.assertStringNotNullOrEmpty(consumerGroup, "consumerGroup");
        ConsumerGroupGetCheckPointRequest request = new ConsumerGroupGetCheckPointRequest(project, logStore, consumerGroup, shard);
        Map<String, String> urlParameter = request.GetAllParams();
        String resourceUri = "/logstores/" + logStore + "/consumergroups/" + consumerGroup;
        Map<String, String> headParameter = this.GetCommonHeadPara(project);
        ResponseMessage response = this.SendData(project, HttpMethod.GET, resourceUri, urlParameter, headParameter);
        Map<String, String> resHeaders = response.getHeaders();
        String requestId = this.GetRequestId(resHeaders);
        JSONArray array = this.ParseResponseMessageToArray(response, requestId);
        ConsumerGroupCheckPointResponse consumerGroupCheckPointResponse = new ConsumerGroupCheckPointResponse(resHeaders, array);
        return consumerGroupCheckPointResponse;
    }
}

