/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.anno.SerialPolicy;
import com.alicp.jetcache.anno.method.SpringCacheContext;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringConfigProvider
extends ConfigProvider
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public CacheContext newContext(GlobalCacheConfig globalCacheConfig) {
        return new SpringCacheContext(globalCacheConfig, this.applicationContext);
    }

    private String parseBeanName(String str) {
        String beanPrefix = "bean:";
        int len = "bean:".length();
        if (str != null && str.startsWith("bean:") && str.length() > len) {
            return str.substring(len);
        }
        return null;
    }

    @Override
    public Function<Object, byte[]> parseValueEncoder(String valueEncoder) {
        String beanName = this.parseBeanName(valueEncoder);
        if (beanName == null) {
            return super.parseValueEncoder(valueEncoder);
        }
        Object bean = this.applicationContext.getBean(beanName);
        if (bean instanceof Function) {
            return (Function)bean;
        }
        return ((SerialPolicy)bean).encoder();
    }

    @Override
    public Function<byte[], Object> parseValueDecoder(String valueDecoder) {
        String beanName = this.parseBeanName(valueDecoder);
        if (beanName == null) {
            return super.parseValueDecoder(valueDecoder);
        }
        Object bean = this.applicationContext.getBean(beanName);
        if (bean instanceof Function) {
            return (Function)bean;
        }
        return ((SerialPolicy)bean).decoder();
    }

    @Override
    public Function<Object, Object> parseKeyConvertor(String convertor) {
        String beanName = this.parseBeanName(convertor);
        if (beanName == null) {
            return super.parseKeyConvertor(convertor);
        }
        return (Function)this.applicationContext.getBean(beanName);
    }
}

