/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.sts.fetcher.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class StsFetcherConfigOptions {
    public static StsFetcherConfigOption ALICLOUD_STS_CREDENTIAL_PROVIDER = StsFetcherConfigOption.builder().key("alicloud.sts.credential.provider").defaultValue("").description("").availableValues(Arrays.asList("sts.file", "sts.http")).build();
    public static StsFetcherConfigOption STS_PROVIDER_CREDENTIAL_ROOT_PATH = StsFetcherConfigOption.builder().key("sts.provider.file.credential.root.path").description("").build();
    public static StsFetcherConfigOption STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_ID_FILENAME = StsFetcherConfigOption.builder().key("sts.provider.file.credential.ak.id.filename").defaultValue("sts.accessKeyId").build();
    public static StsFetcherConfigOption STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_SECRET_FILENAME = StsFetcherConfigOption.builder().key("sts.provider.file.credential.ak.secret.filename").defaultValue("sts.accessKeySecret").build();
    public static StsFetcherConfigOption STS_PROVIDER_FILE_CREDENTIAL_ACCESS_KEY_TOKEN_FILENAME = StsFetcherConfigOption.builder().key("sts.provider.file.credential.ak.token.filename").defaultValue("sts.token").build();
    public static StsFetcherConfigOption STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_ID_ADDRESS = StsFetcherConfigOption.builder().key("sts.provider.http.credential.ak.id.address").defaultValue("http://localhost:10011/role-access-key-id").build();
    public static StsFetcherConfigOption STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_SECRET_ADDRESS = StsFetcherConfigOption.builder().key("sts.provider.http.credential.ak.secret.address").defaultValue("http://localhost:10011/role-access-key-secret").build();
    public static StsFetcherConfigOption STS_PROVIDER_HTTP_CREDENTIAL_ACCESS_KEY_TOKEN_ADDRESS = StsFetcherConfigOption.builder().key("sts.provider.http.credential.ak.token.address").defaultValue("http://localhost:10011/role-security-token").build();
    public static StsFetcherConfigOption STS_PROVIDER_CREDENTIAL_EXPIRE_SECONDS = StsFetcherConfigOption.builder().key("sts.provider.credential.expire.seconds").defaultValue("3600").build();

    public static Optional<String> getValue(Properties properties, StsFetcherConfigOption configOption) {
        if (properties.getProperty(configOption.getKey()) == null) {
            if (configOption.getDefaultValue() == null) {
                return Optional.empty();
            }
            return Optional.of(configOption.getDefaultValue());
        }
        return Optional.of(properties.getProperty(configOption.getKey()));
    }

    public static Optional<String> getValue(Map<String, String> configMap, StsFetcherConfigOption configOption) {
        if (configMap.get(configOption.getKey()) == null) {
            if (configOption.getDefaultValue() == null) {
                return Optional.empty();
            }
            return Optional.of(configOption.getDefaultValue());
        }
        return Optional.of(configMap.get(configOption.getKey()));
    }

    public static class StsFetcherConfigOption {
        private String key;
        private String value;
        private String defaultValue;
        private List<String> availableValues;
        private String description;

        StsFetcherConfigOption(String key, String value, String defaultValue, List<String> availableValues, String description) {
            this.key = key;
            this.value = value;
            this.defaultValue = defaultValue;
            this.availableValues = availableValues;
            this.description = description;
        }

        public static StsFetcherConfigOptionBuilder builder() {
            return new StsFetcherConfigOptionBuilder();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public List<String> getAvailableValues() {
            return this.availableValues;
        }

        public String getDescription() {
            return this.description;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setAvailableValues(List<String> availableValues) {
            this.availableValues = availableValues;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StsFetcherConfigOption)) {
                return false;
            }
            StsFetcherConfigOption other = (StsFetcherConfigOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            List<String> this$availableValues = this.getAvailableValues();
            List<String> other$availableValues = other.getAvailableValues();
            if (this$availableValues == null ? other$availableValues != null : !((Object)this$availableValues).equals(other$availableValues)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StsFetcherConfigOption;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            List<String> $availableValues = this.getAvailableValues();
            result = result * 59 + ($availableValues == null ? 43 : ((Object)$availableValues).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "StsFetcherConfigOptions.StsFetcherConfigOption(key=" + this.getKey() + ", value=" + this.getValue() + ", defaultValue=" + this.getDefaultValue() + ", availableValues=" + this.getAvailableValues() + ", description=" + this.getDescription() + ")";
        }

        public static class StsFetcherConfigOptionBuilder {
            private String key;
            private String value;
            private String defaultValue;
            private List<String> availableValues;
            private String description;

            StsFetcherConfigOptionBuilder() {
            }

            public StsFetcherConfigOptionBuilder key(String key) {
                this.key = key;
                return this;
            }

            public StsFetcherConfigOptionBuilder value(String value) {
                this.value = value;
                return this;
            }

            public StsFetcherConfigOptionBuilder defaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public StsFetcherConfigOptionBuilder availableValues(List<String> availableValues) {
                this.availableValues = availableValues;
                return this;
            }

            public StsFetcherConfigOptionBuilder description(String description) {
                this.description = description;
                return this;
            }

            public StsFetcherConfigOption build() {
                return new StsFetcherConfigOption(this.key, this.value, this.defaultValue, this.availableValues, this.description);
            }

            public String toString() {
                return "StsFetcherConfigOptions.StsFetcherConfigOption.StsFetcherConfigOptionBuilder(key=" + this.key + ", value=" + this.value + ", defaultValue=" + this.defaultValue + ", availableValues=" + this.availableValues + ", description=" + this.description + ")";
            }
        }
    }
}

