/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import com.alibaba.ververica.connectors.common.util.FactoryOptionUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ContextUtil.class);
    public static final String TABLE_DYNAMIC_OPTION_PREFIX = "table.dynamic.option.";

    public static DynamicTableFactory.Context normalizeContext(DynamicTableFactory factory, DynamicTableFactory.Context context) {
        Map catalogOptions = context.getCatalogTable().getOptions();
        Map<String, String> convertedOptions = FactoryOptionUtil.normalizeOptionCaseAsFactory((Factory)factory, catalogOptions);
        return new FactoryUtil.DefaultDynamicTableContext(context.getObjectIdentifier(), context.getCatalogTable().copy(convertedOptions), context.getConfiguration(), context.getClassLoader(), context.isTemporary());
    }

    public static DynamicTableFactory.Context mergeTableOptionsFromTableConfig(DynamicTableFactory.Context context) {
        HashMap optionsFromTableConfig = new HashMap();
        Map tableConfiguration = ((Configuration)context.getConfiguration()).toMap();
        LOG.info("Loading table options from {} table configuration(s) for table {}", (Object)tableConfiguration.size(), (Object)context.getObjectIdentifier());
        tableConfiguration.keySet().forEach(option -> {
            LOG.info("TableConfig: {}={}", option, tableConfiguration.get(option));
            if (!option.startsWith(TABLE_DYNAMIC_OPTION_PREFIX)) {
                return;
            }
            int left = TABLE_DYNAMIC_OPTION_PREFIX.length();
            for (int i = 0; i < 3; ++i) {
                int right = ContextUtil.seekNextCharacter(option, '.', left);
                if (right < 0) {
                    return;
                }
                String identifierInConfig = option.substring(left, right);
                String identifierOfTable = null;
                switch (i) {
                    case 0: {
                        identifierOfTable = context.getObjectIdentifier().getCatalogName();
                        break;
                    }
                    case 1: {
                        identifierOfTable = context.getObjectIdentifier().getDatabaseName();
                        break;
                    }
                    case 2: {
                        identifierOfTable = context.getObjectIdentifier().getObjectName();
                    }
                }
                if (!identifierInConfig.equals("*") && !identifierInConfig.equals(identifierOfTable)) {
                    return;
                }
                left = right + 1;
            }
            String trimmedKey = option.substring(left);
            optionsFromTableConfig.put(trimmedKey, tableConfiguration.get(option));
        });
        if (optionsFromTableConfig.isEmpty()) {
            LOG.info("No option found in table config. ");
        } else {
            LOG.info("Merging options in table config: {}", optionsFromTableConfig);
        }
        optionsFromTableConfig.putAll(context.getCatalogTable().getOptions());
        return new FactoryUtil.DefaultDynamicTableContext(context.getObjectIdentifier(), context.getCatalogTable().copy(optionsFromTableConfig), context.getConfiguration(), context.getClassLoader(), context.isTemporary());
    }

    private static int seekNextCharacter(String string, char character, int start) {
        for (int i = start; i < string.length(); ++i) {
            if (string.charAt(i) != character) continue;
            return i;
        }
        return -1;
    }
}

