/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionPool<T> {
    private final Map<String, T> pools = new ConcurrentHashMap<String, T>();
    private final Map<String, Integer> referenceCounts = new ConcurrentHashMap<String, Integer>();

    public synchronized boolean contains(String dataSourceName) {
        return this.pools.containsKey(dataSourceName);
    }

    public synchronized T get(String dataSourceName) {
        this.referenceCounts.put(dataSourceName, this.referenceCounts.get(dataSourceName) + 1);
        return this.pools.get(dataSourceName);
    }

    public synchronized T put(String dataSourceName, T dataSource) {
        this.referenceCounts.put(dataSourceName, 1);
        return this.pools.put(dataSourceName, dataSource);
    }

    public synchronized boolean remove(String dataSourceName) {
        Integer count = this.referenceCounts.get(dataSourceName);
        if (count == null) {
            return false;
        }
        if (count == 1) {
            this.referenceCounts.remove(dataSourceName);
            this.pools.remove(dataSourceName);
            return true;
        }
        this.referenceCounts.put(dataSourceName, count - 1);
        return false;
    }

    public synchronized int size() {
        return this.pools.size();
    }
}

