/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver.parse;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.source.message.BytesMessage;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.alibaba.ververica.connectors.common.source.resolver.parse.AbstractHighSpeedParser;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;

public class DefaultHighSpeedParser
extends AbstractHighSpeedParser {
    private static final int LINE_DELIMITER_LEN = 1;
    private final GenericRowData reuseRow;
    private final MemorySegment[] reuseSegs;
    private final Object[] reuseObj;
    private final byte[] fieldDelimiterBytes;
    private final byte[] lineDelimiterBytes;
    private final int fieldDelimiterLen;
    private final DirtyDataStrategy formatErrorStrategy;
    private final DirtyDataStrategy fieldMissingStrategy;
    private final DirtyDataStrategy fieldIncrementStrategy;
    private final Meter parserTpsMetrics;
    private final Counter parserSkipMetrics;

    public DefaultHighSpeedParser(ByteSerializer.ValueType[] fieldTypes, DataType[] fieldDataTypes, String fieldDelimiter, String lineDelimiter, boolean splitByWholeSeparator, @Nullable Set<String> nullValues, DirtyDataStrategy formatErrorStrategy, DirtyDataStrategy fieldMissingStrategy, DirtyDataStrategy fieldIncrementStrategy, boolean columnErrorDebug, Meter parserTpsMetrics, Counter parserSkipMetrics) {
        super(fieldTypes, fieldDataTypes, fieldDelimiter, splitByWholeSeparator, (List<String>)(nullValues == null ? Collections.emptyList() : new ArrayList<String>(nullValues)), columnErrorDebug);
        this.reuseRow = new GenericRowData(this.columnSize);
        this.reuseSegs = new MemorySegment[1];
        this.reuseSegs[0] = MemorySegmentFactory.wrap((byte[])new byte[32]);
        this.reuseObj = new Object[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            if (fieldTypes[i] != ByteSerializer.ValueType.V_String) continue;
            this.reuseObj[i] = new BinaryStringData();
        }
        this.fieldDelimiterBytes = fieldDelimiter.getBytes();
        this.lineDelimiterBytes = lineDelimiter.getBytes();
        this.fieldDelimiterLen = splitByWholeSeparator ? this.fieldDelimiterBytes.length : 1;
        this.formatErrorStrategy = formatErrorStrategy;
        this.fieldMissingStrategy = fieldMissingStrategy;
        this.fieldIncrementStrategy = fieldIncrementStrategy;
        this.parserTpsMetrics = parserTpsMetrics;
        this.parserSkipMetrics = parserSkipMetrics;
    }

    @Override
    public void parseBytesMessageByBinary(Collector<RowData> collector, RawMessage<?> msg) {
        byte[] readBuffer = ((BytesMessage)msg).getData();
        this.reuseSegs[0] = MemorySegmentFactory.wrap((byte[])readBuffer);
        int lineReadPos = 0;
        block0: while (lineReadPos < readBuffer.length) {
            int lineIndex = lineReadPos;
            lineReadPos = DefaultHighSpeedParser.findAnyBytesDelimiter(readBuffer, lineReadPos, readBuffer.length, this.lineDelimiterBytes);
            int lineEnd = lineReadPos++;
            int lineStart = lineIndex;
            if (this.columnSize == 1) {
                if (this.parseField(readBuffer, 0, lineStart, lineEnd, lineStart, lineEnd)) {
                    continue;
                }
            } else {
                for (int i = 0; i < this.columnSize; ++i) {
                    if (lineIndex > lineEnd || lineIndex == lineEnd && i == 0) {
                        if (!this.handleFieldMiss(readBuffer, i, lineStart, lineEnd - lineStart)) break;
                        continue block0;
                    }
                    int fieldHead = lineIndex;
                    int n = lineIndex = this.splitByWholeSeparator ? DefaultHighSpeedParser.findBytesDelimiter(readBuffer, fieldHead, lineEnd, this.fieldDelimiterBytes) : DefaultHighSpeedParser.findAnyBytesDelimiter(readBuffer, fieldHead, lineEnd, this.fieldDelimiterBytes);
                    if (this.parseField(readBuffer, i, lineStart, lineEnd, fieldHead, lineIndex)) continue block0;
                    lineIndex += this.fieldDelimiterLen;
                }
            }
            if (lineIndex != lineEnd + this.fieldDelimiterLen && this.handleExtraField(readBuffer, lineStart, lineEnd - lineStart)) continue;
            collector.collect((Object)this.reuseRow);
            if (this.parserTpsMetrics == null) continue;
            this.parserTpsMetrics.markEvent();
        }
    }

    private boolean parseField(byte[] readBuffer, int fieldOrdinal, int lineStart, int lineEnd, int fieldStart, int fieldEnd) {
        try {
            if (this.isNullField(readBuffer, fieldStart, fieldEnd - fieldStart)) {
                this.reuseRow.setField(fieldOrdinal, null);
            } else {
                this.reuseRow.setField(fieldOrdinal, this.deserializeBinaryNotNull(readBuffer, fieldStart, fieldEnd, fieldOrdinal, this.reuseObj[fieldOrdinal], this.reuseSegs));
            }
        }
        catch (Exception e) {
            return this.handleParseException(readBuffer, lineStart, lineEnd - lineStart, fieldOrdinal, e);
        }
        return false;
    }

    private boolean handleFieldMiss(byte[] readBuffer, int idx, int lineStart, int lineLen) {
        boolean skip = false;
        switch (this.fieldMissingStrategy) {
            case SKIP: {
                this.logFieldMiss(readBuffer, lineStart, lineLen);
                skip = true;
                break;
            }
            case SKIP_SILENT: {
                if (this.parserSkipMetrics != null) {
                    this.parserSkipMetrics.inc();
                }
                skip = true;
                break;
            }
            case CUT: 
            case NULL: 
            case PAD: {
                for (int j = idx; j < this.columnSize; ++j) {
                    this.reuseRow.setField(j, null);
                }
                break;
            }
            case EXCEPTION: {
                Object[] data = this.toFieldStringArray(readBuffer, lineStart, lineLen);
                throw new RuntimeException(ConnectorErrors.INST.parserFieldMissingError(String.valueOf(this.columnSize), String.valueOf(this.columnSize), String.valueOf(data.length), StringUtils.join(data, ",")));
            }
        }
        return skip;
    }

    private boolean handleExtraField(byte[] readBuffer, int lineStart, int lineLen) {
        boolean skip = false;
        switch (this.fieldIncrementStrategy) {
            case SKIP: {
                this.logExtraField(readBuffer, lineStart, lineLen);
                skip = true;
                break;
            }
            case SKIP_SILENT: {
                if (this.parserSkipMetrics != null) {
                    this.parserSkipMetrics.inc();
                }
                skip = true;
                break;
            }
            case CUT: 
            case NULL: 
            case PAD: {
                break;
            }
            case EXCEPTION: {
                Object[] data = this.toFieldStringArray(readBuffer, lineStart, lineLen);
                throw new RuntimeException(ConnectorErrors.INST.parserFieldIncrementError(String.valueOf(this.columnSize), String.valueOf(this.columnSize), String.valueOf(data.length), StringUtils.join(data, ",")));
            }
        }
        return skip;
    }

    private boolean handleParseException(byte[] readBuffer, int lineStart, int lineLen, int idx, Exception cause) {
        boolean skip = false;
        switch (this.formatErrorStrategy) {
            case SKIP: {
                this.logParseException(readBuffer, lineStart, lineLen, idx, cause);
                skip = true;
                break;
            }
            case SKIP_SILENT: {
                if (this.parserSkipMetrics != null) {
                    this.parserSkipMetrics.inc();
                }
                skip = true;
                break;
            }
            case CUT: 
            case NULL: 
            case PAD: {
                this.reuseRow.setField(idx, null);
                break;
            }
            case EXCEPTION: {
                Object[] dataArray = this.toFieldStringArray(readBuffer, lineStart, lineLen);
                throw new RuntimeException(ConnectorErrors.INST.parserDataFormatError(String.valueOf((Object)this.fieldTypes[idx]), String.valueOf(dataArray[idx]), String.valueOf(idx), StringUtils.join(dataArray, ",")), cause);
            }
        }
        return skip;
    }

    private static int findBytesDelimiter(byte[] array, int start, int end, byte[] delimiter) {
        for (int i = start; i < end && i + delimiter.length <= end; ++i) {
            boolean equal = true;
            for (int j = 0; j < delimiter.length; ++j) {
                if (delimiter[j] == array[i + j]) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            return i;
        }
        return end;
    }

    private static int findAnyBytesDelimiter(byte[] array, int start, int end, byte[] delimiter) {
        for (int i = start; i < end; ++i) {
            for (byte b : delimiter) {
                if (b != array[i]) continue;
                return i;
            }
        }
        return end;
    }
}

