/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.resolver.parse;

import com.alibaba.ververica.connectors.common.source.message.BytesMessage;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.source.resolver.parse.AbstractHighSpeedParser;
import com.alibaba.ververica.connectors.common.source.resolver.parse.BufferedTextRowData;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Meter;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class BufferedTextRowHighSpeedParser
extends AbstractHighSpeedParser {
    private final int columnSize;
    private final int[] earlyParsingFields;
    private final byte fieldDelim;
    private final byte lineDelim;
    private final BufferedTextRowData reuseRow;
    private final Meter parserTpsMetrics;

    public BufferedTextRowHighSpeedParser(ByteSerializer.ValueType[] fieldTypes, DataType[] fieldDataTypes, String fieldDelimiter, String lineDelimiter, @Nullable Set<String> nullValues, boolean columnErrorDebug, Meter parserTpsMetrics) {
        super(fieldTypes, fieldDataTypes, fieldDelimiter, false, (List<String>)(nullValues == null ? Collections.emptyList() : new ArrayList<String>(nullValues)), columnErrorDebug);
        this.columnSize = fieldTypes.length;
        this.earlyParsingFields = BufferedTextRowHighSpeedParser.getEarlyParsingFields(fieldTypes);
        byte[] fieldDelimBytes = fieldDelimiter.getBytes();
        Preconditions.checkArgument((fieldDelimBytes.length == 1 ? 1 : 0) != 0, (Object)"Field delimiter must have only 1 byte");
        this.fieldDelim = fieldDelimiter.getBytes()[0];
        byte[] lineDelimBytes = lineDelimiter.getBytes();
        Preconditions.checkArgument((lineDelimBytes.length == 1 ? 1 : 0) != 0, (Object)"Line delimiter must have only 1 byte");
        this.lineDelim = lineDelimiter.getBytes()[0];
        this.reuseRow = new BufferedTextRowData(fieldTypes);
        this.parserTpsMetrics = parserTpsMetrics;
    }

    private static int[] getEarlyParsingFields(ByteSerializer.ValueType[] fieldTypes) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        block3: for (int i = 0; i < fieldTypes.length; ++i) {
            switch (fieldTypes[i]) {
                case V_ByteArray: 
                case V_String: {
                    continue block3;
                }
                default: {
                    result.add(i);
                }
            }
        }
        return result.stream().mapToInt(x -> x).toArray();
    }

    @Override
    public void parseBytesMessageByBinary(Collector<RowData> collector, RawMessage<?> msg) {
        byte[] readBuffer = ((BytesMessage)msg).getData();
        this.reuseRow.replaceBuffer(readBuffer);
        int lineStart = 0;
        int fieldStart = 0;
        int fieldIdx = 0;
        for (int cursor = 0; cursor <= readBuffer.length; ++cursor) {
            if (cursor == readBuffer.length || readBuffer[cursor] == this.lineDelim) {
                this.setField(readBuffer, fieldStart, cursor - fieldStart, fieldIdx);
                if (++fieldIdx < this.columnSize) {
                    this.logFieldMiss(readBuffer, lineStart, cursor - lineStart);
                } else if (this.earlyParse(lineStart, cursor - lineStart)) {
                    collector.collect((Object)this.reuseRow);
                    if (this.parserTpsMetrics != null) {
                        this.parserTpsMetrics.markEvent();
                    }
                }
                lineStart = cursor + 1;
                fieldStart = cursor + 1;
                fieldIdx = 0;
                continue;
            }
            if (readBuffer[cursor] != this.fieldDelim) continue;
            this.setField(readBuffer, fieldStart, cursor - fieldStart, fieldIdx);
            ++fieldIdx;
            fieldStart = cursor + 1;
        }
    }

    private void setField(byte[] buffer, int start, int length, int idx) {
        if (idx < this.columnSize) {
            if (this.isNullField(buffer, start, length)) {
                this.reuseRow.setNullAt(idx);
            } else {
                this.reuseRow.setNotNullAt(idx);
                this.reuseRow.setPointersAt(idx, start, length);
            }
        }
    }

    private boolean earlyParse(int lineStart, int lineLen) {
        for (int idx : this.earlyParsingFields) {
            if (this.reuseRow.isNullAt(idx)) continue;
            int start = this.reuseRow.getStart(idx);
            int len = this.reuseRow.getLength(idx);
            try {
                this.reuseRow.setField(idx, this.deserializeBinaryNotNull(this.reuseRow.getBuffer(), start, start + len, idx, null, null));
            }
            catch (Exception e) {
                this.logParseException(this.reuseRow.getBuffer(), lineStart, lineLen, idx, e);
                return false;
            }
        }
        return true;
    }
}

