/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.source.deserializer;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.metrics.SimpleGauge;
import com.alibaba.ververica.connectors.common.source.deserializer.RecordDeserializationSchema;
import com.alibaba.ververica.connectors.common.source.message.BytesMessage;
import com.alibaba.ververica.connectors.common.source.message.ListByteMessage;
import com.alibaba.ververica.connectors.common.source.message.ListMessage;
import com.alibaba.ververica.connectors.common.source.message.ListStringMessage;
import com.alibaba.ververica.connectors.common.source.message.RawMessage;
import com.alibaba.ververica.connectors.common.source.resolver.DefaultSourceCollector;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.alibaba.ververica.connectors.common.source.resolver.parse.AbstractHighSpeedParser;
import com.alibaba.ververica.connectors.common.source.resolver.parse.BufferedTextRowHighSpeedParser;
import com.alibaba.ververica.connectors.common.source.resolver.parse.DefaultHighSpeedParser;
import com.alibaba.ververica.connectors.common.util.ByteSerializer;
import com.alibaba.ververica.connectors.common.util.ByteString;
import com.alibaba.ververica.connectors.common.util.StringSerializer;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceDeserializer
implements RecordDeserializationSchema<List<RawMessage<?>>, RowData> {
    private static final long serialVersionUID = -4053363045803644643L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultSourceDeserializer.class);
    private static final int DEFAULT_LOG_INTERVAL_MS = 60000;
    private static final String RG_TAG = "__blink_rg__tag__";
    boolean highSpeed;
    private transient TableSchema schema;
    private int totalColumnSize;
    private int dataColumnSize;
    private Map<Integer, Integer> dataIndexMapping;
    private Set<String> headerFields;
    private Set<String> nullValues;
    private final DirtyDataStrategy formatErrorStrategy;
    private final DirtyDataStrategy fieldMissingStrategy;
    private final DirtyDataStrategy fieldIncrementStrategy;
    private final DirtyDataStrategy colLenStrategy;
    private final String fieldDelimiter;
    private final String encoding;
    private final String lineDelimiter;
    private String sourceType = "";
    private ByteSerializer.ValueType[] fieldTypes;
    private boolean columnErrorDebug;
    private SimpleGauge batchReadCount;
    private long lastLogExceptionTime;
    private long lastLogHandleFieldTime;
    private boolean splitByWholeSeparator = false;
    private Map<Integer, Integer> colIndexLenFilter;
    private Map<String, Integer> colNameIndexMap;
    private final Map<String, String> properties;
    private transient Object[] reuseObj;
    private AbstractHighSpeedParser highSpeedParser;
    private transient DataType[] fieldDataTypes;
    private final boolean hasMetadata;
    private final DefaultSourceCollector.MetadataCollector metadataCollector;

    DefaultSourceDeserializer(TableSchema schema, List<String> headerFields, Map<String, String> properties, DirtyDataStrategy formatErrorStrategy, DirtyDataStrategy fieldMissingStrategy, DirtyDataStrategy fieldIncrementStrategy, DirtyDataStrategy colLenStrategy, String fieldDelimiter, String encoding, String lineDelimiter, boolean hasMetadata, DefaultSourceCollector.MetadataConverter[] metadataConverters) {
        this.formatErrorStrategy = formatErrorStrategy;
        this.fieldMissingStrategy = fieldMissingStrategy;
        this.fieldIncrementStrategy = fieldIncrementStrategy;
        this.colLenStrategy = colLenStrategy;
        this.fieldDelimiter = StringEscapeUtils.unescapeJava(fieldDelimiter);
        this.encoding = encoding;
        this.lineDelimiter = StringEscapeUtils.unescapeJava(lineDelimiter);
        this.schema = schema;
        if (headerFields != null) {
            this.headerFields = new HashSet<String>(headerFields);
        }
        this.properties = properties;
        this.hasMetadata = hasMetadata;
        this.metadataCollector = new DefaultSourceCollector.MetadataCollector(hasMetadata, metadataConverters);
        this.init();
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) {
        DescriptorProperties config = new DescriptorProperties();
        config.putProperties(this.properties);
        this.schema = SchemaValidator.deriveTableSinkSchema((DescriptorProperties)config);
        this.fieldDataTypes = this.schema.getFieldDataTypes();
        this.batchReadCount = (SimpleGauge)context.getMetricGroup().gauge("currentNumRecordsPerBatch", (Gauge)new SimpleGauge());
        this.lastLogExceptionTime = System.currentTimeMillis();
        this.lastLogHandleFieldTime = System.currentTimeMillis();
        this.initHighSpeed();
    }

    @VisibleForTesting
    void initHighSpeed() {
        if (this.canUsePointerHighSpeedParser()) {
            this.highSpeedParser = new BufferedTextRowHighSpeedParser(this.fieldTypes, this.fieldDataTypes, this.fieldDelimiter, this.lineDelimiter, this.nullValues, this.columnErrorDebug, null);
            this.highSpeed = true;
        } else if (this.canUseDefaultHighSpeedParser()) {
            this.highSpeedParser = new DefaultHighSpeedParser(this.fieldTypes, this.fieldDataTypes, this.fieldDelimiter, this.lineDelimiter, this.splitByWholeSeparator, this.nullValues, this.formatErrorStrategy, this.fieldMissingStrategy, this.fieldIncrementStrategy, this.columnErrorDebug, null, null);
            this.highSpeed = true;
        }
    }

    private boolean canUsePointerHighSpeedParser() {
        return this.encoding.equalsIgnoreCase("UTF-8") && this.lineDelimiter.getBytes().length == 1 && this.fieldDelimiter.getBytes().length == 1 && this.totalColumnSize == this.dataColumnSize && this.colIndexLenFilter.size() == 0 && this.totalColumnSize > 1 && this.formatErrorStrategy == DirtyDataStrategy.SKIP && this.fieldMissingStrategy == DirtyDataStrategy.SKIP && this.fieldIncrementStrategy == DirtyDataStrategy.CUT && !this.hasMetadata;
    }

    private boolean canUseDefaultHighSpeedParser() {
        return this.encoding.equalsIgnoreCase("UTF-8") && this.lineDelimiter.getBytes().length == this.lineDelimiter.length() && (this.splitByWholeSeparator || this.fieldDelimiter.getBytes().length == this.fieldDelimiter.length()) && this.totalColumnSize == this.dataColumnSize && this.colIndexLenFilter.size() == 0;
    }

    public DefaultSourceDeserializer setColumnErrorDebug(boolean columnErrorDebug) {
        this.columnErrorDebug = columnErrorDebug;
        return this;
    }

    private void init() {
        int i;
        logger.info("Init Method!");
        this.totalColumnSize = this.schema.getFieldNames().length;
        this.fieldTypes = new ByteSerializer.ValueType[this.totalColumnSize];
        this.dataColumnSize = 0;
        this.colNameIndexMap = new HashMap<String, Integer>();
        this.dataIndexMapping = new HashMap<Integer, Integer>();
        for (i = 0; i < this.schema.getFieldNames().length; ++i) {
            this.colNameIndexMap.put(this.schema.getFieldNames()[i], i);
        }
        for (i = 0; i < this.totalColumnSize; ++i) {
            ByteSerializer.ValueType type = ByteSerializer.getTypeIndex(this.schema.getFieldTypes()[i].getTypeClass());
            this.fieldTypes[i] = type;
            if (this.isHeaderField(i)) continue;
            this.dataIndexMapping.put(this.dataColumnSize, i);
            ++this.dataColumnSize;
        }
        if (null == this.properties) {
            logger.info("Properties is null!");
            return;
        }
        Configuration config = new Configuration();
        for (String key : this.properties.keySet()) {
            config.setString(key, this.properties.get(key));
        }
        String colFilterList = config.getString(DefaultSourceCollector.CollectorOption.COLUMN_LENGTH_FILTER);
        String[] colFilterArray = StringUtils.split(colFilterList, ";");
        this.colIndexLenFilter = new HashMap<Integer, Integer>();
        for (String string : colFilterArray) {
            String[] colLen = StringUtils.split(string, ":");
            if (colLen == null || colLen.length != 2 || StringUtils.isEmpty(colLen[0]) || StringUtils.isEmpty(colLen[1]) || !this.colNameIndexMap.containsKey(colLen[0]) || !this.isStringType(colLen[0])) continue;
            try {
                int length = Integer.parseInt(colLen[1]);
                this.colIndexLenFilter.put(this.colNameIndexMap.get(colLen[0]), length);
            }
            catch (NumberFormatException e) {
                logger.warn("column filter length illegal:" + colLen[1]);
            }
        }
        if (this.colIndexLenFilter.size() > 0) {
            logger.info("Parser using column filter:" + colFilterList);
        }
        this.splitByWholeSeparator = config.getBoolean(DefaultSourceCollector.CollectorOption.PARSER_SPLIT_BY_WHOLE_SEPARATOR);
        String nullValuesStr = config.getString(DefaultSourceCollector.CollectorOption.PARSER_NULL_VALUES);
        String nullValuesDelimiter = config.getString(DefaultSourceCollector.CollectorOption.PARSER_NULL_VALUES_DELIMITER);
        if (null != nullValuesStr) {
            this.nullValues = new HashSet<String>();
            if (nullValuesStr.contains(nullValuesDelimiter)) {
                String[] tmpValues;
                for (String s : tmpValues = StringUtils.splitPreserveAllTokens(nullValuesStr, nullValuesDelimiter)) {
                    this.nullValues.add(StringEscapeUtils.unescapeJava(s));
                }
            } else {
                this.nullValues.add(StringEscapeUtils.unescapeJava(nullValuesStr));
            }
            logger.info("nullValues: " + this.nullValues);
            for (String string : this.nullValues) {
                logger.info("nullValues: " + string);
            }
        }
    }

    private boolean isStringType(String fieldName) {
        TypeInformation typeInformation = this.schema.getFieldTypes()[this.colNameIndexMap.get(fieldName)];
        if (null != typeInformation) {
            ByteSerializer.ValueType type = ByteSerializer.getTypeIndex(typeInformation.getTypeClass());
            return type == ByteSerializer.ValueType.V_String;
        }
        return false;
    }

    private boolean isByteArrayType(String fieldName) {
        TypeInformation typeInformation = this.schema.getFieldTypes()[this.colNameIndexMap.get(fieldName)];
        if (null != typeInformation) {
            ByteSerializer.ValueType type = ByteSerializer.getTypeIndex(typeInformation.getTypeClass());
            return type == ByteSerializer.ValueType.V_ByteArray;
        }
        return false;
    }

    private boolean isHeaderField(int index) {
        return this.headerFields != null && this.headerFields.contains(this.schema.getFieldNames()[index]);
    }

    private String getHeaderValue(RawMessage<?> msg, int index) {
        Object obj = msg.getProperty(this.schema.getFieldNames()[index]);
        return obj != null ? (String)obj : "";
    }

    private String getValue(RawMessage<?> msg, String[] data, String line, int idx) {
        String fieldValue = null;
        if (this.isHeaderField(idx)) {
            fieldValue = this.getHeaderValue(msg, idx);
        } else if (this.dataColumnSize == 1) {
            fieldValue = line;
        } else if (idx < data.length) {
            fieldValue = data[idx];
        }
        return fieldValue;
    }

    private boolean isOnlyHaveVarbinaryDataField() {
        if (this.dataColumnSize == 1 && this.dataIndexMapping.size() == 1) {
            int idx = this.dataIndexMapping.get(0);
            return this.isByteArrayType(this.schema.getFieldNames()[idx]);
        }
        return false;
    }

    private boolean isAllHeaderField() {
        return null != this.headerFields && this.headerFields.size() == this.schema.getFieldNames().length;
    }

    @Override
    public void deserialize(List<RawMessage<?>> messages, Collector<RowData> collector) {
        this.metadataCollector.collector = collector;
        this.parseRawMessage(messages, this.metadataCollector);
    }

    private void parseRawMessage(List<RawMessage<?>> messages, DefaultSourceCollector.MetadataCollector collector) {
        if (null == messages || messages.size() == 0) {
            return;
        }
        if (this.batchReadCount != null) {
            this.batchReadCount.report(messages.size());
        }
        for (RawMessage<?> msg : messages) {
            GenericRowData row;
            collector.message = msg;
            if (msg instanceof ListMessage) {
                GenericRowData row2 = new GenericRowData(this.totalColumnSize);
                Object records = ((ListMessage)msg).getData();
                long length = 0L;
                boolean isRGData = msg.getProperties() != null && msg.getProperties().containsKey(RG_TAG);
                Iterator iterator = records.iterator();
                while (iterator.hasNext()) {
                    int i;
                    Object[] fields = (Object[])iterator.next();
                    boolean skip = false;
                    if (msg instanceof ListStringMessage) {
                        String[] strFields = (String[])fields;
                        for (i = 0; i < strFields.length; ++i) {
                            try {
                                row2.setField(i, StringSerializer.deserialize(strFields[i], this.fieldTypes[i], this.fieldDataTypes[i], isRGData));
                                if (fields[i] == null) continue;
                                length += (long)strFields[i].length();
                                continue;
                            }
                            catch (Exception e) {
                                skip = this.handleException(row2, i, fields, e);
                            }
                        }
                    } else if (msg instanceof ListByteMessage) {
                        ByteString[] byteFields = (ByteString[])fields;
                        for (i = 0; i < byteFields.length; ++i) {
                            try {
                                row2.setField(i, StringSerializer.deserialize(byteFields[i], this.fieldTypes[i], this.fieldDataTypes[i], isRGData, this.reuseObj[i]));
                                if (fields[i] == null) continue;
                                length += (long)byteFields[i].size();
                                continue;
                            }
                            catch (Exception e) {
                                skip = this.handleException(row2, i, Arrays.stream(byteFields).map(bytes -> bytes == null ? null : bytes.toStringUtf8()).toArray(), e);
                            }
                        }
                    } else {
                        throw new RuntimeException();
                    }
                    if (skip) continue;
                    collector.collect((RowData)row2);
                }
                continue;
            }
            int length = 0;
            if (null != ((BytesMessage)msg).getData()) {
                length = ((BytesMessage)msg).getData().length;
            }
            if (this.isOnlyHaveVarbinaryDataField()) {
                row = new GenericRowData(this.totalColumnSize);
                int dataIdx = this.dataIndexMapping.get(0);
                row.setField(dataIdx, (Object)((BytesMessage)msg).getData());
                for (int i = 0; i < this.totalColumnSize; ++i) {
                    if (i == dataIdx) continue;
                    String headerValue = this.getHeaderValue(msg, i);
                    row.setField(i, StringSerializer.deserialize(headerValue, this.fieldTypes[i], this.fieldDataTypes[i], this.nullValues));
                }
                collector.collect((RowData)row);
                continue;
            }
            if (this.isAllHeaderField()) {
                row = new GenericRowData(this.totalColumnSize);
                for (int i = 0; i < this.totalColumnSize; ++i) {
                    String headerValue = this.getHeaderValue(msg, i);
                    row.setField(i, StringSerializer.deserialize(headerValue, this.fieldTypes[i], this.fieldDataTypes[i], this.nullValues));
                }
                collector.collect((RowData)row);
                continue;
            }
            if (null == msg.getData()) {
                logger.info("Empty ByteMessage Body, Ignore It.");
                return;
            }
            if (this.highSpeed) {
                this.highSpeedParser.parseBytesMessageByBinary(collector, msg);
                continue;
            }
            this.parseBytesMessageByString(collector, msg);
        }
    }

    private void parseBytesMessageByString(Collector<RowData> collector, RawMessage<?> msg) {
        String[] lineArray;
        String lines;
        try {
            lines = new String(((BytesMessage)msg).getData(), this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(ConnectorErrors.INST.parserUnsupportedEncodingError(this.encoding), e);
        }
        for (String line : lineArray = StringUtils.split(lines, this.lineDelimiter)) {
            Object[] data = !this.splitByWholeSeparator ? StringUtils.splitPreserveAllTokens(line, this.fieldDelimiter) : StringUtils.splitByWholeSeparatorPreserveAllTokens(line, this.fieldDelimiter);
            if (this.dataColumnSize == 1) {
                data = new String[]{line};
            }
            if (data.length < this.dataColumnSize) {
                data = this.handleFieldMissing((String[])data);
            } else if (data.length > this.dataColumnSize) {
                data = this.handleFieldIncrement((String[])data);
            }
            if (data == null) continue;
            GenericRowData row = new GenericRowData(this.totalColumnSize);
            boolean skip = false;
            Set<Integer> colFilterOrd = this.colIndexLenFilter.keySet();
            for (int idx = 0; idx < this.totalColumnSize; ++idx) {
                String fieldValue;
                try {
                    fieldValue = this.getValue(msg, (String[])data, line, idx);
                    row.setField(idx, StringSerializer.deserialize(fieldValue, this.fieldTypes[idx], this.fieldDataTypes[idx], this.nullValues));
                }
                catch (Exception e) {
                    skip = this.handleException(row, idx, data, e);
                }
                if (colFilterOrd.isEmpty() || !colFilterOrd.contains(idx) || (fieldValue = this.getValue(msg, (String[])data, line, idx)) == null) continue;
                Object filterResult = this.handleFiledLengthLarge(fieldValue, this.colIndexLenFilter.get(idx));
                if (filterResult == null) {
                    skip = true;
                    break;
                }
                row.setField(idx, StringSerializer.deserialize(fieldValue, this.fieldTypes[idx], this.fieldDataTypes[idx], this.nullValues));
            }
            if (skip) continue;
            collector.collect((Object)row);
        }
    }

    private boolean handleException(GenericRowData row, int idx, Object[] data, Exception e) {
        boolean skip = false;
        switch (this.formatErrorStrategy) {
            case SKIP: {
                long now = System.currentTimeMillis();
                if (this.columnErrorDebug || now - this.lastLogExceptionTime > 60000L) {
                    logger.warn("Data format error, field type: " + (Object)((Object)this.fieldTypes[idx]) + "field data: " + data[idx] + ", index: " + idx + ", data: [" + StringUtils.join(data, ",") + "]", (Throwable)e);
                    this.lastLogExceptionTime = now;
                }
                skip = true;
                break;
            }
            case SKIP_SILENT: {
                skip = true;
                break;
            }
            default: {
                row.setField(idx, null);
                break;
            }
            case EXCEPTION: {
                throw new RuntimeException(ConnectorErrors.INST.parserDataFormatError(String.valueOf((Object)this.fieldTypes[idx]), String.valueOf(data[idx]), String.valueOf(idx), StringUtils.join(data, ",")), e);
            }
        }
        return skip;
    }

    private String[] handleFieldMissing(String[] data) {
        switch (this.fieldMissingStrategy) {
            default: {
                long now = System.currentTimeMillis();
                if (this.columnErrorDebug || now - this.lastLogHandleFieldTime > 60000L) {
                    logger.warn("Field missing error, table column number: " + this.totalColumnSize + ", data column number: " + this.dataColumnSize + ", data field number: " + data.length + ", data: [" + StringUtils.join((Object[])data, ",") + "]");
                    this.lastLogHandleFieldTime = now;
                }
                return null;
            }
            case SKIP_SILENT: {
                return null;
            }
            case CUT: 
            case NULL: 
            case PAD: {
                String[] res = new String[this.totalColumnSize];
                for (int i = 0; i < data.length; ++i) {
                    Integer dataIdx = this.dataIndexMapping.get(i);
                    if (dataIdx == null) continue;
                    res[dataIdx.intValue()] = data[i];
                }
                return res;
            }
            case EXCEPTION: 
        }
        throw new RuntimeException(ConnectorErrors.INST.parserFieldMissingError(String.valueOf(this.totalColumnSize), String.valueOf(this.dataColumnSize), String.valueOf(data.length), StringUtils.join((Object[])data, ",")));
    }

    private String[] handleFieldIncrement(String[] data) {
        switch (this.fieldIncrementStrategy) {
            case SKIP: {
                long now = System.currentTimeMillis();
                if (this.columnErrorDebug || now - this.lastLogHandleFieldTime > 60000L) {
                    logger.warn("Field increment error, table column number: " + this.totalColumnSize + ", data column number: " + this.dataColumnSize + ", data field number: " + data.length + ", data: [" + StringUtils.join((Object[])data, ",") + "]");
                    this.lastLogHandleFieldTime = now;
                }
                return null;
            }
            case SKIP_SILENT: {
                return null;
            }
            default: {
                String[] res = new String[this.totalColumnSize];
                for (int i = 0; i < this.dataColumnSize; ++i) {
                    Integer dataIdx = this.dataIndexMapping.get(i);
                    if (dataIdx == null) continue;
                    res[dataIdx.intValue()] = data[i];
                }
                return res;
            }
            case EXCEPTION: 
        }
        throw new RuntimeException(ConnectorErrors.INST.parserFieldIncrementError(String.valueOf(this.totalColumnSize), String.valueOf(this.dataColumnSize), String.valueOf(data.length), StringUtils.join((Object[])data, ",")));
    }

    private Object handleFiledLengthLarge(String data, int length) {
        if (data != null && data.length() > length) {
            switch (this.colLenStrategy) {
                case SKIP: {
                    long now = System.currentTimeMillis();
                    if (this.columnErrorDebug || now - this.lastLogHandleFieldTime > 60000L) {
                        logger.warn("Field too long error, data length: " + data.length() + ", exceed specified length: " + length + ", data: [" + data + "]");
                        this.lastLogHandleFieldTime = now;
                    }
                    return null;
                }
                case SKIP_SILENT: {
                    return null;
                }
            }
            long ts = System.currentTimeMillis();
            if (this.columnErrorDebug || ts - this.lastLogHandleFieldTime > 60000L) {
                logger.warn("Field too long error, data length: " + data.length() + ", exceed specified length: " + length + ", data: [" + data + "], use cut strategy to cut field value");
                this.lastLogHandleFieldTime = ts;
            }
            return data.substring(0, length);
        }
        return data;
    }

    public TypeInformation<RowData> getProducedType() {
        return InternalTypeInfo.of((RowType)((RowType)this.schema.toRowDataType().getLogicalType()));
    }

    public static class Builder {
        Map<String, String> properties;
        String encoding = "UTF-8";
        String lineDelimiter = "\n";
        String fieldDelimiter = "\u0001";
        DirtyDataStrategy formatErrorStrategy = DirtyDataStrategy.SKIP;
        DirtyDataStrategy fieldMissingStrategy = DirtyDataStrategy.SKIP;
        DirtyDataStrategy fieldIncrementStrategy = DirtyDataStrategy.CUT;
        DirtyDataStrategy colLenStrategy = DirtyDataStrategy.SKIP;
        private boolean columnErrorDebug = false;
        private TableSchema schema;
        private List<String> headerFields = null;
        private boolean hasMetadata;
        private DefaultSourceCollector.MetadataConverter[] metadataConverters;

        public Builder setTableSchema(TableSchema tableSchema) {
            this.schema = tableSchema;
            return this;
        }

        public Builder setHeaderFields(List<String> headerFields) {
            this.headerFields = headerFields;
            return this;
        }

        public Builder setFormatErrorStrategy(DirtyDataStrategy formatErrorStrategy) {
            this.formatErrorStrategy = formatErrorStrategy;
            return this;
        }

        public Builder setFieldMissingStrategy(DirtyDataStrategy fieldMissingStrategy) {
            this.fieldMissingStrategy = fieldMissingStrategy;
            return this;
        }

        public Builder setFieldIncrementStrategy(DirtyDataStrategy fieldIncrementStrategy) {
            this.fieldIncrementStrategy = fieldIncrementStrategy;
            return this;
        }

        public Builder setColLenStrategy(DirtyDataStrategy colLenStrategy) {
            this.colLenStrategy = colLenStrategy;
            return this;
        }

        public Builder setColumnErrorDebug(boolean columnErrorDebug) {
            this.columnErrorDebug = columnErrorDebug;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            if (null == properties) {
                return this;
            }
            Configuration config = new Configuration();
            for (String key : properties.keySet()) {
                config.setString(key, properties.get(key));
            }
            String lengthCheck = (String)config.get(DefaultSourceCollector.CollectorOption.LENGTH_CHECK);
            switch (lengthCheck.toUpperCase()) {
                case "SKIP": {
                    this.setFormatErrorStrategy(DirtyDataStrategy.SKIP);
                    this.setFieldMissingStrategy(DirtyDataStrategy.SKIP);
                    this.setFieldIncrementStrategy(DirtyDataStrategy.SKIP);
                    this.setColLenStrategy(DirtyDataStrategy.SKIP);
                    break;
                }
                case "PAD": {
                    this.setFormatErrorStrategy(DirtyDataStrategy.SKIP);
                    this.setFieldMissingStrategy(DirtyDataStrategy.PAD);
                    this.setFieldIncrementStrategy(DirtyDataStrategy.CUT);
                    this.setColLenStrategy(DirtyDataStrategy.SKIP);
                    break;
                }
                case "EXCEPTION": {
                    this.setFormatErrorStrategy(DirtyDataStrategy.EXCEPTION);
                    this.setFieldMissingStrategy(DirtyDataStrategy.EXCEPTION);
                    this.setFieldIncrementStrategy(DirtyDataStrategy.EXCEPTION);
                    this.setColLenStrategy(DirtyDataStrategy.SKIP);
                    break;
                }
                case "SKIP_SILENT": {
                    this.setFormatErrorStrategy(DirtyDataStrategy.SKIP_SILENT);
                    this.setFieldMissingStrategy(DirtyDataStrategy.SKIP_SILENT);
                    this.setFieldIncrementStrategy(DirtyDataStrategy.SKIP_SILENT);
                    this.setColLenStrategy(DirtyDataStrategy.SKIP_SILENT);
                    break;
                }
            }
            this.setColumnErrorDebug(config.getBoolean(DefaultSourceCollector.CollectorOption.COLUMN_ERROR_DEBUG));
            this.setFieldDelimiter(config.getString(DefaultSourceCollector.CollectorOption.FIELD_DELIMITER));
            this.setLineDelimiter(config.getString(DefaultSourceCollector.CollectorOption.LINE_DELIMITER));
            this.setEncoding(config.getString(DefaultSourceCollector.CollectorOption.ENCODING));
            if (!com.alibaba.ververica.connectors.common.util.StringUtils.isBlank(config.getString(DefaultSourceCollector.CollectorOption.PARSER_HEADER_FIELDS), ",")) {
                this.headerFields = Lists.newArrayList((Object[])config.getString(DefaultSourceCollector.CollectorOption.PARSER_HEADER_FIELDS).split(","));
            }
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setLineDelimiter(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public Builder setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder setMetadataConverters(DefaultSourceCollector.MetadataConverter[] metadataConverters) {
            this.metadataConverters = metadataConverters;
            return this;
        }

        public Builder setHasMetadata(boolean hasMetadata) {
            this.hasMetadata = hasMetadata;
            return this;
        }

        public DefaultSourceDeserializer build() {
            DefaultSourceDeserializer defaultSourceDeserializer = new DefaultSourceDeserializer(this.schema, this.headerFields, this.properties, this.formatErrorStrategy, this.fieldMissingStrategy, this.fieldIncrementStrategy, this.colLenStrategy, this.fieldDelimiter, this.encoding, this.lineDelimiter, this.hasMetadata, this.metadataConverters);
            defaultSourceDeserializer.setColumnErrorDebug(this.columnErrorDebug);
            return defaultSourceDeserializer;
        }
    }
}

