/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.sink.converter;

import com.alibaba.ververica.connectors.common.sink.converter.RecordConverter;
import com.alibaba.ververica.connectors.common.table.VervericaTableOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.StringUtils;

public class RecordConverterUtil {
    public static <IN, OUT> RecordConverter<IN, OUT> getRecordConverter(Configuration properties, ClassLoader classLoader) {
        RecordConverter converter;
        String collectorClass = properties.getString(VervericaTableOptions.CONVERTER_CLASS);
        if (!StringUtils.isNullOrWhitespaceOnly((String)collectorClass)) {
            try {
                converter = (RecordConverter)Class.forName(collectorClass, true, classLoader).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("new instance of SourceCollector fail", e);
            }
        } else {
            return null;
        }
        return converter;
    }
}

