/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.metrics;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;

public class Latency {
    private static final long AVG_INTERVAL = 10000L;
    private double sum;
    private Counter count;
    private long currentAvgTime;
    private double currentAvg;
    private long nextIntervalKey;
    private double avgSum;
    private int avgCount;

    public Latency(String name, MetricGroup metricGroup) {
        MetricGroup group = metricGroup.addGroup(name);
        this.count = group.counter("count");
        group.gauge("sum", (Gauge)new Gauge<Double>(){

            public Double getValue() {
                return Latency.this.sum;
            }
        });
        group.gauge("avg", (Gauge)new Gauge<Double>(){

            public Double getValue() {
                if (System.currentTimeMillis() - Latency.this.currentAvgTime > 10000L) {
                    return 0.0;
                }
                return Latency.this.currentAvg;
            }
        });
    }

    @VisibleForTesting
    public Latency(String name) {
        this.sum = 0.0;
        this.count = new SimpleCounter();
    }

    public void update(long value) {
        this.update(1L, value);
    }

    public void update(long countUpdated, long value) {
        this.count.inc(countUpdated);
        this.sum += (double)value;
        long now = System.currentTimeMillis();
        if (now / 10000L > this.nextIntervalKey) {
            this.nextIntervalKey = now / 10000L;
            this.currentAvgTime = this.nextIntervalKey * 10000L;
            this.currentAvg = this.avgCount == 0 ? 0.0 : this.avgSum / (double)this.avgCount;
            this.avgCount = 0;
            this.avgSum = 0.0;
        }
        ++this.avgCount;
        this.avgSum += (double)value;
    }

    public double getSum() {
        return this.sum;
    }

    public Counter getCounter() {
        return this.count;
    }
}

