/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim.cache;

import com.alibaba.ververica.connectors.common.dim.cache.AllCache;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.io.disk.RandomAccessInputView;
import org.apache.flink.runtime.io.disk.SimpleCollectingOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;

public class BinaryAllCacheBase<V>
extends AllCache<Object, V> {
    protected final RowDataSerializer keySer;
    protected final RowDataSerializer valSer;
    private final transient LazyMemorySegmentPool memoryPool = new LazyMemorySegmentPool(null, null, Integer.MAX_VALUE);
    private transient ArrayList<MemorySegment> segments = new ArrayList();
    private transient ArrayList<MemorySegment> tmpSegments;
    private transient SimpleCollectingOutputView outView;
    private transient RandomAccessInputView inView;

    public BinaryAllCacheBase(RowDataSerializer keySer, RowDataSerializer valSer) {
        this.keySer = keySer;
        this.valSer = valSer;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.tmpSegments = new ArrayList();
        this.outView = new SimpleCollectingOutputView(this.tmpSegments, (MemorySegmentSource)this.memoryPool, 32768);
        this.inView = new RandomAccessInputView(this.tmpSegments, 32768);
    }

    protected RowData keyToBinary(RowData key) throws IOException {
        long oldPosition = this.outView.getCurrentOffset();
        int skip = this.keySer.serializeToPages(key, (AbstractPagedOutputView)this.outView);
        this.inView.setReadPosition(oldPosition + (long)skip);
        key = this.keySer.mapFromPages(key, (AbstractPagedInputView)this.inView);
        return key;
    }

    protected RowData valToBinary(RowData value) throws IOException {
        BinaryRowData bVal = new BinaryRowData(value.getArity());
        long oldPosition = this.outView.getCurrentOffset();
        int skip = this.valSer.serializeToPages(value, (AbstractPagedOutputView)this.outView);
        this.inView.setReadPosition(oldPosition + (long)skip);
        value = this.valSer.mapFromPages((RowData)bVal, (AbstractPagedInputView)this.inView);
        return value;
    }

    @Override
    public void switchCacheInner() {
        super.switchCacheInner();
        this.memoryPool.cleanCache();
        this.segments.clear();
        this.segments = this.tmpSegments;
        this.tmpSegments = null;
    }
}

