/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.common.dim;

import com.alibaba.ververica.connectors.common.dim.RuntimeContextWrapper;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.FunctionContext;

public class AsyncLookupFunctionWrapper
extends AsyncTableFunction<RowData> {
    private static final long serialVersionUID = 6941593589582551911L;
    private final AsyncFunction<RowData, RowData> fetcher;

    public AsyncLookupFunctionWrapper(AsyncFunction<RowData, RowData> fetcher) {
        this.fetcher = fetcher;
    }

    public void open(FunctionContext context) throws Exception {
        super.open(context);
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)new RuntimeContextWrapper(context));
        FunctionUtils.openFunction(this.fetcher, (Configuration)new Configuration());
    }

    public void eval(CompletableFuture<Collection<RowData>> result, Object ... inputs) throws Exception {
        GenericRowData row = GenericRowData.of((Object[])inputs);
        this.fetcher.asyncInvoke((Object)row, (ResultFuture)new AsyncFunctionResultFuture(result));
    }

    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.fetcher);
    }

    public static class AsyncFunctionResultFuture
    implements ResultFuture<RowData> {
        CompletableFuture<Collection<RowData>> actualResult;

        public AsyncFunctionResultFuture(CompletableFuture<Collection<RowData>> result) {
            this.actualResult = result;
        }

        public void complete(Collection<RowData> collection) {
            this.actualResult.complete(collection);
        }

        public void completeExceptionally(Throwable throwable) {
            this.actualResult.completeExceptionally(throwable);
        }
    }
}

