/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common.namesrv;

import com.alibaba.rocketmq.common.MixAll;
import com.alibaba.rocketmq.common.help.FAQUrl;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopAddressing {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private HttpClient httpClient = new HttpClient();
    private String nsAddr;

    public TopAddressing() {
        HttpConnectionManagerParams managerParams = this.httpClient.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(5000);
        managerParams.setSoTimeout(5000);
    }

    private static String clearNewLine(String str) {
        String newString = str.trim();
        int index = newString.indexOf("\r");
        if (index != -1) {
            return newString.substring(0, index);
        }
        index = newString.indexOf("\n");
        if (index != -1) {
            return newString.substring(0, index);
        }
        return newString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String fetchNSAddr() {
        GetMethod httpMethod = null;
        try {
            httpMethod = new GetMethod(MixAll.WS_ADDR);
            int httpStatus = this.httpClient.executeMethod((HttpMethod)httpMethod);
            if (200 == httpStatus) {
                byte[] responseBody = httpMethod.getResponseBody();
                if (responseBody != null) {
                    String responseStr = new String(responseBody);
                    String string = TopAddressing.clearNewLine(responseStr);
                    return string;
                }
                log.error("httpMethod.getResponseBody() return null");
            } else {
                log.error("HttpClient.executeMethod return not OK, " + httpStatus);
            }
        }
        catch (HttpException e) {
            log.error("fetchZKAddr exception", (Throwable)e);
        }
        catch (IOException e) {
            log.error("fetchZKAddr exception", (Throwable)e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        String errorMsg = "connect to " + MixAll.WS_ADDR + " failed, maybe the domain name " + MixAll.WS_DOMAIN_NAME + " not bind in /etc/hosts";
        errorMsg = errorMsg + FAQUrl.suggestTodo("https://github.com/alibaba/RocketMQ/issues/57");
        log.warn(errorMsg);
        System.out.println(errorMsg);
        return null;
    }

    protected void doOnNSAddrChanged(String newNSAddr) {
    }

    public void tryToAddressing() {
        try {
            String newNSAddr = this.fetchNSAddr();
            if (!(newNSAddr == null || null != this.nsAddr && newNSAddr.equals(this.nsAddr))) {
                log.info("nsaddr in top web server changed, " + newNSAddr);
                this.doOnNSAddrChanged(newNSAddr);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    public String getNsAddr() {
        return this.nsAddr;
    }

    public void setNsAddr(String nsAddr) {
        this.nsAddr = nsAddr;
    }
}

