/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common;

import com.alibaba.rocketmq.common.annotation.ImportantField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class MixAll {
    public static final String ROCKETMQ_HOME_ENV = "ROCKETMQ_HOME";
    public static final String ROCKETMQ_HOME_PROPERTY = "rocketmq.home.dir";
    public static final String NAMESRV_ADDR_ENV = "NAMESRV_ADDR";
    public static final String NAMESRV_ADDR_PROPERTY = "rocketmq.namesrv.addr";
    public static final String WS_DOMAIN_NAME = System.getProperty("rocketmq.namesrv.domain", "jmenv.tbsite.net");
    public static final String MESSAGE_COMPRESS_LEVEL = "rocketmq.message.compressLevel";
    public static final String WS_ADDR = "http://" + WS_DOMAIN_NAME + ":8080/rocketmq/nsaddr";
    public static final String DEFAULT_TOPIC = "TBW102";
    public static final String BENCHMARK_TOPIC = "BenchmarkTest";
    public static final String DEFAULT_PRODUCER_GROUP = "DEFAULT_PRODUCER";
    public static final String DEFAULT_CONSUMER_GROUP = "DEFAULT_CONSUMER";
    public static final String TOOLS_CONSUMER_GROUP = "TOOLS_CONSUMER";
    public static final String CLIENT_INNER_PRODUCER_GROUP = "CLIENT_INNER_PRODUCER";
    public static final String SELF_TEST_TOPIC = "SELF_TEST_TOPIC";
    public static final List<String> LocalInetAddrs = MixAll.getLocalInetAddress();
    public static final String Localhost = MixAll.localhost();
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long MASTER_ID = 0L;
    public static final long CURRENT_JVM_PID = MixAll.getPID();
    public static final String RETRY_GROUP_TOPIC_PREFIX = "%RETRY%";
    public static final String DLQ_GROUP_TOPIC_PREFIX = "%DLQ%";

    public static String getRetryTopic(String consumerGroup) {
        return RETRY_GROUP_TOPIC_PREFIX + consumerGroup;
    }

    public static String getDLQTopic(String consumerGroup) {
        return DLQ_GROUP_TOPIC_PREFIX + consumerGroup;
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        if (processName != null && processName.length() > 0) {
            try {
                return Long.parseLong(processName.split("@")[0]);
            }
            catch (Exception e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static long createBrokerId(String ip, int port) {
        InetSocketAddress isa = new InetSocketAddress(ip, port);
        byte[] ipArray = isa.getAddress().getAddress();
        ByteBuffer bb = ByteBuffer.allocate(8);
        bb.put(ipArray);
        bb.putInt(port);
        long value = bb.getLong(0);
        return Math.abs(value);
    }

    public static final void string2File(String str, String fileName) throws IOException {
        String tmpFile = fileName + ".tmp";
        MixAll.string2FileNotSafe(str, tmpFile);
        String bakFile = fileName + ".bak";
        String prevContent = MixAll.file2String(fileName);
        if (prevContent != null) {
            MixAll.string2FileNotSafe(prevContent, bakFile);
        }
        File file = new File(fileName);
        file.delete();
        file = new File(tmpFile);
        file.renameTo(new File(fileName));
    }

    public static final void string2FileNotSafe(String str, String fileName) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null) {
            fileParent.mkdirs();
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(str);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String file2String(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            char[] data = new char[(int)file.length()];
            boolean result = false;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                int len = fileReader.read(data);
                result = len == data.length;
            }
            catch (IOException e) {
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (result) {
                String value = new String(data);
                return value;
            }
        }
        return null;
    }

    public static String findClassPath(Class<?> c) {
        URL url = c.getProtectionDomain().getCodeSource().getLocation();
        return url.getPath();
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("h", "help", false, "Print help");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("n", "namesrvAddr", true, "Name server address list, eg: 192.168.1.100:9876;192.168.1.101:9876");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static CommandLine parseCmdLine(String appName, String[] args, Options options, CommandLineParser parser) {
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(110);
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                hf.printHelp(appName, options, true);
                return null;
            }
        }
        catch (ParseException e) {
            hf.printHelp(appName, options, true);
        }
        return commandLine;
    }

    public static void printCommandLineHelp(String appName, Options options) {
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(110);
        hf.printHelp(appName, options, true);
    }

    public static Properties commandLine2Properties(CommandLine commandLine) {
        Properties properties = new Properties();
        Option[] opts = commandLine.getOptions();
        if (opts != null) {
            for (Option opt : opts) {
                String name = opt.getLongOpt();
                String value = commandLine.getOptionValue(name);
                if (value == null) continue;
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    public static void printObjectProperties(Logger log, Object object) {
        MixAll.printObjectProperties(log, object, false);
    }

    public static void printObjectProperties(Logger log, Object object, boolean onlyImportantField) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            ImportantField annotation;
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
                if (null == value) {
                    value = "";
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println(e);
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
            if (onlyImportantField && null == (annotation = field.getAnnotation(ImportantField.class))) continue;
            if (log != null) {
                log.info(name + "=" + value);
                continue;
            }
            System.out.println(name + "=" + value);
        }
    }

    public static String properties2String(Properties properties) {
        Set<Object> sets = properties.keySet();
        StringBuilder sb = new StringBuilder();
        for (Object key : sets) {
            Object value = properties.get(key);
            if (value == null) continue;
            sb.append(key.toString() + "=" + value.toString() + IOUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static Properties string2Properties(String str) {
        Properties properties = new Properties();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(DEFAULT_CHARSET));
            properties.load(in);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return properties;
    }

    public static Properties object2Properties(Object object) {
        Field[] fields;
        Properties properties = new Properties();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
            }
            catch (IllegalArgumentException e) {
                System.out.println(e);
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
            if (value == null) continue;
            properties.setProperty(name, value.toString());
        }
        return properties;
    }

    public static void properties2Object(Properties p, Object object) {
        Method[] methods;
        for (Method method : methods = object.getClass().getMethods()) {
            String mn = method.getName();
            if (!mn.startsWith("set")) continue;
            try {
                Class<?>[] pt;
                String tmp = mn.substring(4);
                String first = mn.substring(3, 4);
                String key = first.toLowerCase() + tmp;
                String property = p.getProperty(key);
                if (property == null || (pt = method.getParameterTypes()) == null || pt.length <= 0) continue;
                String cn = pt[0].getSimpleName();
                Object arg = null;
                if (cn.equals("int")) {
                    arg = Integer.parseInt(property);
                } else if (cn.equals("long")) {
                    arg = Long.parseLong(property);
                } else if (cn.equals("double")) {
                    arg = Double.parseDouble(property);
                } else if (cn.equals("boolean")) {
                    arg = Boolean.parseBoolean(property);
                } else {
                    if (!cn.equals("String")) continue;
                    arg = property;
                }
                method.invoke(object, arg);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public static boolean isPropertiesEqual(Properties p1, Properties p2) {
        return p1.equals(p2);
    }

    public static List<String> getLocalInetAddress() {
        ArrayList<String> inetAddressList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    inetAddressList.add(addrs.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("get local inet address fail", e);
        }
        return inetAddressList;
    }

    public static boolean isLocalAddr(String address) {
        for (String addr : LocalInetAddrs) {
            if (!address.contains(addr)) continue;
            return true;
        }
        return false;
    }

    private static String localhost() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("get localhost fail", e);
        }
    }

    public static boolean compareAndIncreaseOnly(AtomicLong target, long value) {
        long prev = target.get();
        while (value > prev) {
            boolean updated = target.compareAndSet(prev, value);
            if (updated) {
                return true;
            }
            prev = target.get();
        }
        return false;
    }

    public Set<String> list2Set(List<String> values) {
        HashSet<String> result = new HashSet<String>();
        for (String v : values) {
            result.add(v);
        }
        return result;
    }

    public List<String> set2List(Set<String> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (String v : values) {
            result.add(v);
        }
        return result;
    }
}

