/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.rocketmq.common;

import com.alibaba.rocketmq.common.MixAll;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigManager {
    private static final Logger plog = LoggerFactory.getLogger((String)"RocketmqCommon");

    public abstract String encode();

    public abstract String encode(boolean var1);

    public abstract void decode(String var1);

    public abstract String configFilePath();

    public boolean load() {
        String fileName = null;
        try {
            fileName = this.configFilePath();
            String jsonString = MixAll.file2String(fileName);
            if (jsonString != null) {
                this.decode(jsonString);
                plog.info("load " + fileName + " OK");
                return true;
            }
        }
        catch (Exception e) {
            plog.error("load " + fileName + " Failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized void persist() {
        String jsonString = this.encode(true);
        if (jsonString != null) {
            String fileName = this.configFilePath();
            try {
                MixAll.string2File(jsonString, fileName);
            }
            catch (IOException e) {
                plog.error("persist file Exception, " + fileName, (Throwable)e);
            }
        }
    }
}

