/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.dubbo.common.utils.UrlUtils;
import com.alibaba.dubbo.registry.NotifyListener;
import com.alibaba.dubbo.registry.support.DubboRegistration;
import com.alibaba.dubbo.registry.support.FailbackRegistry;
import com.alibaba.dubbo.registry.support.Registration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class ServiceInstanceRegistry<S>
extends FailbackRegistry {
    private static final String[] ALL_SUPPORTED_CATEGORIES = ServiceInstanceRegistry.of("providers", "consumers", "routers", "configurators");
    private static final int CATEGORY_INDEX = 0;
    private static final int SERVICE_INTERFACE_INDEX = 1;
    private static final int SERVICE_VERSION_INDEX = 2;
    private static final int SERVICE_GROUP_INDEX = 3;
    private static final String WILDCARD = "*";
    private static final String SERVICE_NAME_SEPARATOR = System.getProperty("dubbo.service.name.separator", ":");
    private static final long LOOKUP_INTERVAL = Long.getLong("dubbo.service.names.lookup.interval", 30L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile ScheduledExecutorService serviceNamesScheduler;

    public ServiceInstanceRegistry(URL url) {
        super(url);
    }

    @Override
    protected final void doRegister(URL url) {
        String serviceName = ServiceInstanceRegistry.getServiceName(url);
        Registration registration = this.createRegistration(serviceName, url);
        this.register(serviceName, this.toServiceInstance(registration), url);
    }

    @Override
    protected final void doUnregister(URL url) {
        String serviceName = ServiceInstanceRegistry.getServiceName(url);
        Registration registration = this.createRegistration(serviceName, url);
        this.deregister(serviceName, this.toServiceInstance(registration), url);
    }

    @Override
    protected final void doSubscribe(URL url, NotifyListener listener) {
        Set<String> serviceNames = this.getServiceNames(url, listener);
        this.doSubscribe(url, listener, serviceNames);
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.shutdownServiceNamesLookup();
        }
    }

    protected abstract S toServiceInstance(Registration var1);

    protected abstract Registration toRegistration(S var1);

    protected abstract void register(String var1, S var2, URL var3);

    protected abstract void deregister(String var1, S var2, URL var3);

    private void doSubscribe(URL url, NotifyListener listener, Set<String> serviceNames) {
        LinkedList<S> serviceInstances = new LinkedList<S>();
        for (String serviceName : serviceNames) {
            serviceInstances.addAll(this.findServiceInstances(serviceName));
        }
        this.notifySubscriber(url, listener, serviceInstances);
    }

    private void notifySubscriber(URL url, NotifyListener listener, Collection<S> serviceInstances) {
        LinkedHashSet<S> healthyServiceInstances = new LinkedHashSet<S>(serviceInstances);
        this.filterHealthyInstances(healthyServiceInstances);
        List<URL> urls = this.buildURLs(url, healthyServiceInstances);
        this.notify(url, listener, urls);
    }

    private void filterHealthyInstances(Collection<S> serviceInstances) {
        this.filter(serviceInstances, new Filter<S>(){

            @Override
            public boolean accept(S serviceInstance) {
                return ServiceInstanceRegistry.this.filterHealthyRegistration(serviceInstance);
            }
        });
    }

    protected abstract Collection<S> findServiceInstances(String var1);

    protected abstract boolean filterHealthyRegistration(S var1);

    private void shutdownServiceNamesLookup() {
        if (this.serviceNamesScheduler != null) {
            this.serviceNamesScheduler.shutdown();
        }
    }

    private void scheduleServiceNamesLookup(final URL url, final NotifyListener listener) {
        if (this.serviceNamesScheduler == null) {
            this.serviceNamesScheduler = Executors.newSingleThreadScheduledExecutor();
            this.serviceNamesScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Set<String> serviceNames = ServiceInstanceRegistry.this.findAllServiceNames();
                    ServiceInstanceRegistry.this.filter(serviceNames, new Filter<String>(){

                        @Override
                        public boolean accept(String serviceName) {
                            boolean accepted = false;
                            for (String category : ALL_SUPPORTED_CATEGORIES) {
                                String prefix = category + SERVICE_NAME_SEPARATOR;
                                if (!serviceName.startsWith(prefix)) continue;
                                accepted = true;
                                break;
                            }
                            return accepted;
                        }
                    });
                    ServiceInstanceRegistry.this.doSubscribe(url, listener, serviceNames);
                }
            }, LOOKUP_INTERVAL, LOOKUP_INTERVAL, TimeUnit.SECONDS);
        }
    }

    protected abstract Set<String> findAllServiceNames();

    private List<URL> buildURLs(URL consumerURL, Collection<S> serviceInstances) {
        if (serviceInstances.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<URL> urls = new LinkedList<URL>();
        for (S serviceInstance : serviceInstances) {
            Registration registration = this.toRegistration(serviceInstance);
            URL url = this.buildURL(registration);
            if (!UrlUtils.isMatch(consumerURL, url)) continue;
            urls.add(url);
        }
        return urls;
    }

    private URL buildURL(Registration registration) {
        URL url = new URL(registration.getMetadata().get("protocol"), registration.getIp(), registration.getPort(), registration.getMetadata());
        return url;
    }

    private Set<String> getSubscribedServiceNamesForOps(URL url) {
        Set<String> serviceNames = this.findAllServiceNames();
        this.filterServiceNames(serviceNames, url);
        return serviceNames;
    }

    private <T> void filter(Collection<T> collection, Filter<T> filter) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            T data = iterator.next();
            if (filter.accept(data)) continue;
            iterator.remove();
        }
    }

    private void filterServiceNames(Set<String> serviceNames, URL url) {
        final String[] categories = this.getCategories(url);
        final String targetServiceInterface = url.getServiceInterface();
        final String targetVersion = url.getParameter("version");
        final String targetGroup = url.getParameter("group");
        this.filter(serviceNames, new Filter<String>(){

            @Override
            public boolean accept(String serviceName) {
                String[] segments = ServiceInstanceRegistry.getServiceSegments(serviceName);
                int length = segments.length;
                if (length < 4) {
                    return false;
                }
                String category = ServiceInstanceRegistry.getCategory(segments);
                if (Arrays.binarySearch(categories, category) > -1) {
                    return false;
                }
                String serviceInterface = ServiceInstanceRegistry.getServiceInterface(segments);
                if (!ServiceInstanceRegistry.WILDCARD.equals(targetServiceInterface) && !StringUtils.isEquals(targetServiceInterface, serviceInterface)) {
                    return false;
                }
                String version = ServiceInstanceRegistry.getServiceVersion(segments);
                if (!ServiceInstanceRegistry.WILDCARD.equals(targetVersion) && !StringUtils.isEquals(targetVersion, version)) {
                    return false;
                }
                String group = ServiceInstanceRegistry.getServiceGroup(segments);
                return group == null || ServiceInstanceRegistry.WILDCARD.equals(targetGroup) || StringUtils.isEquals(targetGroup, group);
            }
        });
    }

    protected Registration createRegistration(String serviceName, URL url) {
        String category = url.getParameter("category", "providers");
        URL newURL = url.addParameter("category", category);
        newURL = newURL.addParameter("protocol", url.getProtocol());
        String ip = url.getHost();
        int port = url.getPort();
        DubboRegistration registration = new DubboRegistration();
        registration.setServiceName(serviceName);
        registration.setIp(ip);
        registration.setPort(port);
        registration.setMetadata(new LinkedHashMap<String, String>(newURL.getParameters()));
        return registration;
    }

    private String[] getCategories(URL url) {
        return WILDCARD.equals(url.getServiceInterface()) ? ALL_SUPPORTED_CATEGORIES : ServiceInstanceRegistry.of("providers");
    }

    private Set<String> getServiceNames(URL url, NotifyListener listener) {
        if (this.isAdminProtocol(url)) {
            this.scheduleServiceNamesLookup(url, listener);
            return this.getSubscribedServiceNamesForOps(url);
        }
        return this.getServiceNames(url);
    }

    private Set<String> getServiceNames(URL url) {
        String[] categories = this.getCategories(url);
        LinkedHashSet<String> serviceNames = new LinkedHashSet<String>(categories.length);
        for (String category : categories) {
            String serviceName = ServiceInstanceRegistry.getServiceName(url, category);
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    private boolean isAdminProtocol(URL url) {
        return "admin".equals(url.getProtocol());
    }

    public static String getServiceName(URL url) {
        String category = url.getParameter("category", "providers");
        return ServiceInstanceRegistry.getServiceName(url, category);
    }

    private static String getServiceName(URL url, String category) {
        StringBuilder serviceNameBuilder = new StringBuilder(category);
        ServiceInstanceRegistry.appendIfPresent(serviceNameBuilder, url, "interface");
        ServiceInstanceRegistry.appendIfPresent(serviceNameBuilder, url, "version");
        ServiceInstanceRegistry.appendIfPresent(serviceNameBuilder, url, "group");
        return serviceNameBuilder.toString();
    }

    private static void appendIfPresent(StringBuilder target, URL url, String parameterName) {
        String parameterValue = url.getParameter(parameterName);
        ServiceInstanceRegistry.appendIfPresent(target, parameterValue);
    }

    public static String[] getServiceSegments(String serviceName) {
        return serviceName.split(SERVICE_NAME_SEPARATOR);
    }

    public static String getCategory(String[] segments) {
        return segments[0];
    }

    public static String getServiceInterface(String[] segments) {
        return segments[1];
    }

    public static String getServiceVersion(String[] segments) {
        return segments[2];
    }

    public static String getServiceGroup(String[] segments) {
        return segments.length > 4 ? segments[3] : null;
    }

    private static <T> T[] of(T ... values) {
        return values;
    }

    private static void appendIfPresent(StringBuilder target, String parameterValue) {
        if (StringUtils.isNotEmpty(parameterValue)) {
            target.append(SERVICE_NAME_SEPARATOR).append(parameterValue);
        }
    }

    private static interface Filter<T> {
        public boolean accept(T var1);
    }
}

