/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.http;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.SerialDetector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectStreamClass;

public class CodebaseAwareObjectInputStream
extends org.springframework.remoting.rmi.CodebaseAwareObjectInputStream {
    private static final Logger logger = LoggerFactory.getLogger(CodebaseAwareObjectInputStream.class);

    public CodebaseAwareObjectInputStream(InputStream in, ClassLoader classLoader, boolean acceptProxyClasses) throws IOException {
        super(in, classLoader, acceptProxyClasses);
    }

    protected Class<?> resolveClass(ObjectStreamClass serialInput) throws IOException, ClassNotFoundException {
        if (SerialDetector.isClassInBlacklist(serialInput)) {
            if (!SerialDetector.shouldCheck()) {
                logger.info(String.format("Blacklist match: '%s'", serialInput.getName()));
            } else {
                logger.error(String.format("Blocked by blacklist'. Match found for '%s'", serialInput.getName()));
                throw new InvalidClassException(serialInput.getName(), "Class blocked from deserialization (blacklist)");
            }
        }
        return super.resolveClass(serialInput);
    }
}

